

<?php $__env->startSection('content'); ?>
<div class="mb-8">
    <a href="<?php echo e(route('blog.view')); ?>" class="text-indigo-600 hover:text-indigo-700 font-semibold flex items-center mb-4 transition-colors">
        <i class="fa-solid fa-arrow-left mr-2"></i> Back to Blogs
    </a>
    <h1 class="text-3xl font-bold text-gray-900">Edit Blog Post</h1>
    <p class="text-gray-500">Update the details of your article below.</p>
</div>

<?php if($errors->any()): ?>
<div class="mb-6 p-4 bg-red-50 border-l-4 border-red-500 text-red-700 rounded-lg shadow-sm">
    <ul class="list-disc list-inside">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
</div>
<?php endif; ?>

<div class="max-w-4xl bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
    <form action="<?php echo e(route('admin.blogs.update', $blog->id)); ?>" method="POST" enctype="multipart/form-data" class="p-8 space-y-6">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div>
            <label class="block text-sm font-bold text-gray-700 mb-2">Blog Title</label>
            <input type="text" name="title" value="<?php echo e($blog->title); ?>" class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 outline-none transition-all" placeholder="Enter blog title...">
        </div>

        <div>
            <label class="block text-sm font-bold text-gray-700 mb-2">Content</label>
            <textarea id="editor" name="content" rows="10" class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 outline-none transition-all"><?php echo e($blog->content); ?></textarea>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <label class="block text-sm font-bold text-gray-700 mb-2">Current Image</label>
                <div class="p-2 border border-gray-100 rounded-xl bg-gray-50 inline-block">
                    <?php if($blog->image): ?>
                        <img src="<?php echo e(asset($blog->image)); ?>" class="w-48 h-32 object-cover rounded-lg shadow-sm">
                    <?php else: ?>
                        <div class="w-48 h-32 bg-gray-200 flex items-center justify-center text-gray-400 rounded-lg">
                            <i class="fa-solid fa-image text-3xl"></i>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div>
                <label class="block text-sm font-bold text-gray-700 mb-2">Change Image</label>
                <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-200 border-dashed rounded-xl hover:border-indigo-400 transition-colors cursor-pointer bg-gray-50 group">
                    <div class="space-y-1 text-center">
                        <i class="fa-solid fa-cloud-arrow-up text-3xl text-gray-400 group-hover:text-indigo-500 transition-colors mb-2"></i>
                        <div class="flex text-sm text-gray-600">
                            <label for="file-upload" class="relative cursor-pointer bg-transparent rounded-md font-semibold text-indigo-600 hover:text-indigo-500 focus-within:outline-none outline-none">
                                <span>Upload new image</span>
                                <input id="file-upload" name="image" type="file" class="sr-only">
                            </label>
                        </div>
                        <p class="text-xs text-gray-500">PNG, JPG up to 2MB</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="pt-4">
            <button type="submit" class="w-full bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-4 rounded-xl transition-all shadow-lg shadow-indigo-200 flex items-center justify-center">
                <i class="fa-solid fa-rotate mr-2"></i> Update Blog Post
            </button>
        </div>
    </form>
</div>

<!-- Premium CKEditor 5 -->
<script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
<style>
    .ck-editor__editable {
        min-height: 300px;
        background-color: #f9fafb !important;
    }
</style>
<script>
    ClassicEditor
        .create(document.querySelector('#editor'), {
            toolbar: [
                'heading', '|', 
                'bold', 'italic', 'link', 'bulletedList', 'numberedList', 'blockQuote', '|',
                'insertTable', 'undo', 'redo'
            ]
        })
        .catch(error => {
            console.error(error);
        });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Rank-fetch\Rank-fetch\resources\views\admin\blog\edit.blade.php ENDPATH**/ ?>