<?php $__env->startSection('title', 'Contact Us | RankFetch - Let\'s Grow Your SEO Visibility'); ?>
<?php $__env->startSection('meta_description', 'Get in touch with RankFetch for all your SEO and link building needs. We help businesses grow online with custom, white-hat backlink strategies.'); ?>

<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<div
    class="breadcumb-wrapper"
    data-bg-src="<?php echo e(asset('assets/img/bg/breadcumb-bg.jpg')); ?>">
    <div
        class="container">
        <div class="breadcumb-content">
            <h1
                class="breadcumb-title">Contact Us</h1>
            <ul
                class="breadcumb-menu">
                <li><a
                        href="<?php echo e(route('home')); ?>">Home</a></li>
                <li>Contact Us
                </li>
            </ul>
        </div>
    </div>
</div>


<div
    class="space">
    <div class="container">
        <div
            class="title-area text-center">
            <h2 class="sec-title">Our
                Contact Information
            </h2>
        </div>
        <div class="row gy-4">
            <div
                class="col-xl-4 col-md-6">
                <div
                    class="contact-media">
                    <div class="icon-btn"><i
                            class="fa-sharp fa-light fa-location-dot"></i></div>
                    <div
                        class="media-body">
                        <h5 class="box-title">Our
                            Address
                        </h5>
                        <p class="box-text">374 William
                            S Canning Blvd, Fall River MA 2721,
                            USA
                        </p>
                    </div>
                </div>
            </div>
            <div
                class="col-xl-4 col-md-6">
                <div
                    class="contact-media">
                    <div class="icon-btn"><i
                            class="fa-light fa-phone"></i></div>
                    <div
                        class="media-body">
                        <h5 class="box-title">Contact
                            Number
                        </h5>
                        <p class="box-text"><a
                                href="tel:+13217322978">Mobile:
                                +13217322978</a> <a
                                href="mailto:saorhelp@gmail.com">Email:
                                saorhelp@gmail.com</a>
                        </p>
                    </div>
                </div>
            </div>
            <div
                class="col-xl-4 col-md-6">
                <div
                    class="contact-media">
                    <div class="icon-btn"><i
                            class="fa-light fa-clock"></i></div>
                    <div
                        class="media-body">
                        <h5 class="box-title">Opening
                            Hour
                        </h5>
                        <p class="box-text">Monday -
                            Saturday: 9:00 - 18:00 Sunday:
                            Closed
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div
    class="space-bottom" id="contact-sec">
    <div class="container">
        <div
            class="row align-items-center">
            <div class="col-12">
                <div class>
                    <form
                        action="<?php echo e(route('contact.store')); ?>"
                        method="POST"
                        class="contact-form style2" id="contact-form">
                        <?php echo csrf_field(); ?>
                        <h3
                            class="text-center mb-30">Get In
                        Touch
                        </h3>
                        <div class="row">
                            <div
                                class="col-md-6 form-group">
                                <input
                                    type="text" name="first_name" placeholder="First Name*"
                                    class="form-control" required> 
                                <i class="far fa-user"></i>
                            </div>
                            <div
                                class="col-md-6 form-group">
                                <input
                                    type="text" name="last_name" placeholder="Last Name*"
                                    class="form-control" required> 
                                <i class="far fa-user"></i>
                            </div>
                            <div
                                class="col-md-6 form-group">
                                <input
                                    type="email" name="email"
                                    placeholder="Email address*"
                                    class="form-control" required> 
                                <i class="far fa-envelope"></i>
                            </div>
                            <div
                                class="form-group col-md-6">
                                <select
                                    name="subject" id="subject"
                                    class="form-select nice-select">
                                    <option
                                        value disabled="disabled"
                                        selected="selected"
                                        hidden>Select
                                        service*
                                    </option>
                                    <option
                                        value="Guest Post Link Building">Guest Post Link Building
                                    </option>
                                    <option
                                        value="Niche Edits (Link Insertions)">Niche Edits (Link Insertions)
                                    </option>
                                    <option
                                        value="EDU Backlinks">EDU Backlinks
                                    </option>
                                    <option
                                        value="PR Links">PR Links
                                    </option>
                                    <option
                                        value="SEO Techniques Backlink">SEO Techniques Backlink
                                    </option>
                                </select>
                            </div>
                            <div
                                class="form-group col-12"><textarea
                                    name="message" id="message"
                                    cols="30" rows="3"
                                    class="form-control"
                                    placeholder="Write a message*" required></textarea>
                                <i class="fal fa-pencil"></i>
                            </div>
                            <div
                                class="col-12 form-group mb-0 text-center"><button
                                    type="submit"
                                    class="th-btn th-radius">Submit
                                    Message</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function() {
        $('#contact-form').on('submit', function(e) {
            e.preventDefault();
            
            let form = $(this);
            let url = form.attr('action');
            let formData = form.serialize();
            let submitBtn = form.find('button[type="submit"]');
            
            // Disable button and show loading state
            submitBtn.prop('disabled', true).html('Sending...');
            
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            title: 'Success!',
                            text: response.message,
                            icon: 'success',
                            confirmButtonColor: '#1e1b4b',
                            confirmButtonText: 'Ok!'
                        });
                        form[0].reset(); // Clear the form
                        $('.nice-select').val(null).trigger('change'); // Reset nice-select if used
                    }
                },
                error: function(xhr) {
                    let errorMessage = 'Something went wrong. Please try again.';
                    if (xhr.status === 422) {
                        errorMessage = 'Please check the form for errors.';
                    }
                    
                    Swal.fire({
                        title: 'Error!',
                        text: errorMessage,
                        icon: 'error',
                        confirmButtonColor: '#ef4444',
                        confirmButtonText: 'Try Again'
                    });
                },
                complete: function() {
                    submitBtn.prop('disabled', false).html('Submit Message');
                }
            });
        });
    });
</script>

<?php if(Session::has('success')): ?>
<script>
    Swal.fire({
        title: 'Success!',
        text: "<?php echo e(Session::get('success')); ?>",
        icon: 'success',
        confirmButtonColor: '#1e1b4b',
        confirmButtonText: 'Ok!'
    });
</script>
<?php endif; ?>

<?php if($errors->any()): ?>
<script>
    Swal.fire({
        title: 'Error!',
        text: "Please check the form for errors.",
        icon: 'error',
        confirmButtonColor: '#ef4444',
        confirmButtonText: 'Try Again'
    });
</script>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\Rank-fetch\resources\views/pages/contact.blade.php ENDPATH**/ ?>