<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="breadcumb-wrapper" data-bg-src="<?php echo e(asset('assets/img/bg/breadcumb-bg.jpg')); ?>">
    <div class="container">
        <div class="breadcumb-content">
            <h1 class="breadcumb-title">Blog</h1>
            <ul class="breadcumb-menu">
                <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                <li>Blog</li>
            </ul>
        </div>
    </div>
</div>

<section class="th-blog-wrapper space-top space-extra-bottom">
    <div class="container">
        <div class="row">
            <div class="col-xxl-8 col-lg-7">
                <?php $__empty_1 = true; $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="th-blog blog-single has-post-thumbnail">
                    <?php if($blog->image): ?>
                    <div class="blog-img">
                        <a href="<?php echo e(route('user.blog.show', $blog->slug)); ?>">
                            <img src="<?php echo e(asset($blog->image)); ?>" alt="<?php echo e($blog->title); ?>" style="width: 100%; max-height: 450px; object-cover: cover;">
                        </a>
                    </div>
                    <?php endif; ?>
                    <div class="blog-content">
                        <div class="blog-meta">
                            <a href="#"><i class="fa-light fa-calendar"></i><?php echo e($blog->created_at->format('M d, Y')); ?></a>
                            <a href="#"><i class="fa-regular fa-clock"></i><?php echo e(ceil(str_word_count(strip_tags($blog->content)) / 200)); ?> min read</a>
                            <a href="#"><i class="fa-light fa-tags"></i> SEO & Link Building</a>
                        </div>
                        <h3 class="blog-title">
                            <a href="<?php echo e(route('user.blog.show', $blog->slug)); ?>"><?php echo e($blog->title); ?></a>
                        </h3>
                        <p class="blog-text">
                            <?php echo Str::limit(strip_tags($blog->content), 200); ?>

                        </p>
                        <a href="<?php echo e(route('user.blog.show', $blog->slug)); ?>" class="th-btn black-border th-icon th-radius">
                            Read More<i class="fa-regular fa-arrow-right ms-2"></i>
                        </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center py-5">
                    <h3 class="text-muted">No blogs found.</h3>
                    <p>Check back later for new content!</p>
                </div>
                <?php endif; ?>

                <div class="th-pagination">
                    <?php echo e($blogs->links('pagination::bootstrap-5')); ?>

                </div>
            </div>

            <div class="col-xxl-4 col-lg-5">
                <aside class="sidebar-area">
                    <div class="widget">
                        <h3 class="widget_title">Recent Posts</h3>
                        <div class="recent-post-wrap">
                            <?php $__currentLoopData = \App\Models\Blog::latest()->take(3)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="recent-post">
                                <?php if($recent->image): ?>
                                <div class="media-img">
                                    <a href="<?php echo e(route('user.blog.show', $recent->slug)); ?>">
                                        <img src="<?php echo e(asset($recent->image)); ?>" alt="<?php echo e($recent->title); ?>">
                                    </a>
                                </div>
                                <?php endif; ?>
                                <div class="media-body">
                                    <div class="recent-post-meta">
                                        <a href="#"><i class="fa-sharp fa-solid fa-calendar-days"></i><?php echo e($recent->created_at->format('d M, Y')); ?></a>
                                    </div>
                                    <h4 class="post-title">
                                        <a class="text-inherit" href="<?php echo e(route('user.blog.show', $recent->slug)); ?>"><?php echo e(Str::limit($recent->title, 40)); ?></a>
                                    </h4>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="widget widget_tag_cloud">
                        <h3 class="widget_title">Popular Tags</h3>
                        <div class="tagcloud">
                            <a href="#">SEO Marketing</a>
                            <a href="#">Design</a>
                            <a href="#">Link Building</a>
                            <a href="#">Guest Post</a>
                            <a href="#">Backlinks</a>
                            <a href="#">Development</a>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Rank-fetch\Rank-fetch\resources\views/pages/blog.blade.php ENDPATH**/ ?>