<?php $__env->startSection('title', 'RankFetch - High-Authority SEO Links & Link Building Services'); ?>
<?php $__env->startSection('meta_description', 'Boost your rankings with RankFetch. We offer high-authority guest posts, niche edits, and white-hat link building services that drive real organic traffic.'); ?>
<?php $__env->startSection('meta_keywords', 'SEO agency, manual outreach, high DR backlinks, guest posting service, niche edits, link building strategy'); ?>

<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="th-hero-wrapper hero-4" id="hero"
    data-bg-src="<?php echo e(asset('assets/img/bg/hero_bg_4.png')); ?>">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-lg-10">
                <div class="hero-style4 text-center">
                    <span class="sub-title text-ani-style2"><span
                            class="square-text"><span
                                class="dot1"></span> <span
                                class="dot2"></span>Welcome to
                            RankFetch</span></span>
                    <h1
                        class="hero-title text-ani-style3">High-Authority
                        <span
                            class="round-line text-theme">SEO</span>
                        Links Google Trusts
                    </h1>
                    <p
                        class="hero-text wow fadeInUp text-center mx-auto"
                        data-wow-delay=".3s"
                        style="max-width: 640px;">RankFetch helps
                        brands, agencies, and startups dominate search
                        results with <strong>white-hat
                            backlinks</strong>, real outreach, and zero
                        spam.</p>

                    <section style="padding-top: 120px !important; padding-bottom: 50px !important;" class="service-area8 space overflow-hidden" id="service-sec">
                        <div class="container">
                            <div class="row gy-4 justify-content-center">

                                <!-- Card 1 -->
                                <div class="col-xl-4 col-lg-4 col-md-6">
                                    <div class="service-grid3">
                                        <div class="box-icon">
                                            <img src="<?php echo e(asset('assets/img/icon/handshake.png')); ?>" alt="Icon">
                                        </div>
                                        <div class="box-content">
                                            <h3 class="box-title">
                                                <a href="service-details.html"> Purely Manual Outreach Only
                                                </a>
                                            </h3>
                                            <!-- <p class="box-text">
                     An SEO agency speciali improving a website's visibility and ranking
                  </p> -->

                                        </div>
                                    </div>
                                </div>

                                <!-- Card 2 -->
                                <div class="col-xl-4 col-lg-4 col-md-6">
                                    <div class="service-grid3">
                                        <div class="box-icon">
                                            <img src="<?php echo e(asset('assets/img/icon/analysis (1).png')); ?>" alt="Icon">
                                        </div>
                                        <div class="box-content">
                                            <h3 class="box-title">
                                                <a href="service-details.html">Real websites, real traffic
                                                </a>
                                            </h3>
                                            <!-- <p class="box-text">
                     An SEO agency speciali improving a website's visibility and ranking
                  </p> -->

                                        </div>
                                    </div>
                                </div>

                                <!-- Card 3 -->
                                <div class="col-xl-4 col-lg-4 col-md-6">
                                    <div class="service-grid3">
                                        <div class="box-icon">
                                            <img src="<?php echo e(asset('assets/img/icon/select.png')); ?>" alt="Icon">
                                        </div>
                                        <div class="box-content">
                                            <h3 class="box-title">
                                                <a href="service-details.html">Scalable for agencies & businesses
                                                </a>
                                            </h3>
                                            <!-- <p class="box-text">
                     An SEO agency speciali improving a website's visibility and ranking
                  </p> -->

                                        </div>
                                    </div>
                                </div>



                            </div>
                        </div>
                    </section>


                    <div
                        class="btn-group wow fadeInUp d-flex justify-content-center flex-wrap"
                        data-wow-delay=".4s">
                        <a href="<?php echo e(route('contact')); ?>"
                            class="th-btn th-icon th-radius">Get Started Now<i
                                class="fa-regular fa-arrow-right ms-2"></i></a>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>

<div class="overflow-hidden space">
    <div class="container">
        <div class="row gy-4 align-items-center">
            <div
                class="col-xl-6">
                <div class="ps-xl-5">
                    <div
                        class="title-area mb-25">
                        <span
                            class="sub-title sub-title9 style1 text-ani-style2">What We Do</span>
                        <h2
                            class="sec-title text-ani-style3">Link Building That Actually Moves Rankings
                        </h2>
                    </div>
                    <p
                        class="mt-n2 mb-25 wow fadeInUp">We build <strong>high-quality backlinks</strong> that improve authority, boost keyword positions, and drive long-term organic traffic.
                    </p>
                    <div
                        class="about-wrapper style2">
                        <div
                            class="checklist style4">
                            <ul>
                                <li
                                    class="wow fadeInUp"
                                    data-wow-delay=".2s"><i
                                        class="fa-solid fa-shield-check"></i>Contextual editorial backlinks
                                </li>
                                <li
                                    class="wow fadeInUp"
                                    data-wow-delay=".3s"><i
                                        class="fa-solid fa-shield-check"></i>Niche-relevant placements
                                </li>
                                <li
                                    class="wow fadeInUp"
                                    data-wow-delay=".4s"><i
                                        class="fa-solid fa-shield-check"></i>DR-verified, traffic-checked sites

                                </li>

                                <li
                                    class="wow fadeInUp"
                                    data-wow-delay=".4s"><i
                                        class="fa-solid fa-shield-check"></i>100% white-hat, Google-safe methods
                                </li>

                                <strong>No PBNs. No link farms. No shortcuts</strong>
                                </li>
                            </ul>
                        </div>

                    </div>
                    <div
                        class="btn-group style3 mt-35 wow fadeInUp"
                        data-wow-delay=".5s"><a href="<?php echo e(route('about')); ?>"
                            class="th-btn th-radius3 th-icon">More
                            About<i
                                class="fa-regular fa-arrow-right ms-2"></i></a>
                    </div>
                </div>
            </div>
            <div class="col-xl-6">
                <div class="img-box6">
                    <div class="img1">
                        <img src="https://images.pexels.com/photos/590016/pexels-photo-590016.jpeg"
                            alt="About">
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<section class="bg-top-center z-index-common space overflow-hidden"
    id="service-sec">
    <div class="container">
        <div
            class="row justify-content-lg-between justify-content-center">
            <div class="col-xl-4">
                <div
                    class="title-area mb-35 text-center text-lg-start pe-xl-5">
                    <span
                        class="sub-title sub-title7 style1 text-ani-style2">Our
                        Services</span>
                    <h2 class="sec-title text-ani-style3">Look Our Link Building Services</h2>
                    <p class="wow fadeInUp" data-wow-delay=".3s">We
                        identify the most relevant and high-traffic
                        keywords for your business. Our team conducts
                        thorough research to understand your industry,
                        competitors, and target audience to ensure your
                        website ranks for terms that matter.</p>
                </div>
                <div
                    class="sec-btn text-center text-lg-start wow fadeInUp"
                    data-wow-delay=".4s"><a href="<?php echo e(route('guest.post')); ?>"
                        class="th-btn th-icon th-radius">View All
                        Services<i
                            class="fa-regular fa-arrow-right ms-2"></i></a></div>
            </div>
            <div class="col-xl-8">
                <div class="service-grid_wrapp">
                    <div class="service-grid hover-item">
                        <div class="box-icon"><img
                                src="<?php echo e(asset('assets/img/icon/service_2_1.svg')); ?>"
                                alt="Icon"></div>
                        <div class="service-grid_content">
                            <h3 class="box-title"><a
                                    href="<?php echo e(route('guest.post')); ?>">Guest Post Backlinks</a></h3>
                            <p class="box-text">Authoritative, niche-relevant guest posts on real websites with organic traffic.</p>
                        </div>
                        <div class="ser-shape"><img
                                src="<?php echo e(asset('assets/img/shape/ser-shape.png')); ?>"
                                alt></div>
                    </div>
                    <div class="service-grid hover-item">
                        <div class="box-icon"><img
                                src="<?php echo e(asset('assets/img/icon/service_2_2.svg')); ?>"
                                alt="Icon"></div>
                        <div class="service-grid_content">
                            <h3 class="box-title"><a
                                    href="<?php echo e(route('seo')); ?>"> Local SEO Links</a></h3>
                            <p class="box-text">Geo-relevant backlinks that help local businesses rank in competitive markets.</p>
                        </div>
                        <div class="ser-shape"><img
                                src="<?php echo e(asset('assets/img/shape/ser-shape.png')); ?>"
                                alt></div>
                    </div>
                    <div class="service-grid hover-item item-active">
                        <div class="box-icon"><img
                                src="<?php echo e(asset('assets/img/icon/service_2_3.svg')); ?>"
                                alt="Icon"></div>
                        <div class="service-grid_content">
                            <h3 class="box-title"><a
                                    href="<?php echo e(route('niche.edits')); ?>"> Niche Edits (Link Insertions)</a></h3>
                            <p class="box-text">Get links placed into existing, aged content for faster SEO impact.</p>
                        </div>
                        <div class="ser-shape"><img
                                src="<?php echo e(asset('assets/img/shape/ser-shape.png')); ?>"
                                alt></div>
                    </div>
                    <div class="service-grid hover-item">
                        <div class="box-icon"><img
                                src="<?php echo e(asset('assets/img/icon/service_2_4.svg')); ?>"
                                alt="Icon"></div>
                        <div class="service-grid_content">
                            <h3 class="box-title"><a
                                    href="<?php echo e(route('pr.links')); ?>">Agency White-Label</a></h3>
                            <p class="box-text">Scalable link building for agencies—fully white-labeled and client-ready.</p>
                        </div>
                        <div class="ser-shape"><img
                                src="<?php echo e(asset('assets/img/shape/ser-shape.png')); ?>"
                                alt></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<section
    class="overflow-hidden space-top space-extra-bottom bg-smoke2"
    id="service-sec">
    <div class="container">
        <div
            class="row justify-content-center align-items-center">
            <div
                class="col-lg-7">
                <div
                    class="title-area text-center">
                    <span
                        class="sub-title sub-title6 style1 text-ani-style2">Who We Help</span>
                    <h2
                        class="sec-title text-ani-style3">If SEO matters to your growth, RankFetch fits.

                    </h2>
                </div>
            </div>
        </div>
        <div
            class="row gy-4">
            <div
                class="service-card tg-img-reveal-item" data-fx="1"
                data-img="assets/img/service/service_1_1.jpg" style>
                <div
                    class="service-wrapp">
                    <div class="box-icon"><img
                            src="<?php echo e(asset('assets/img/icon/saas.png')); ?>"
                            alt="Icon"></div>
                    <h3 class="box-title">SaaS & Startups
                    </h3>
                </div>
                <div
                    class="service-content">
                    <p class="box-text">Grow faster with targeted SEO strategies designed for SaaS and tech startups. Attract your ideal users and scale efficiently.
                    </p>
                    <div class="icon-btn"><a
                            href="service.html"><i
                                class="fa-regular fa-arrow-up-right"></i></a></div>
                </div>
            </div>
            <div
                class="service-card tg-img-reveal-item" data-fx="1"
                data-img="assets/img/service/service_1_2.jpg" style>
                <div
                    class="service-wrapp">
                    <div class="box-icon"><img
                            src="<?php echo e(asset('assets/img/icon/online-store.png')); ?>"
                            alt="Icon"></div>
                    <h3 class="box-title">E-commerce Stores
                    </h3>
                </div>
                <div
                    class="service-content">
                    <p class="box-text">Boost online sales with SEO tactics that drive traffic, increase visibility, and turn visitors into loyal customers.
                    </p>
                    <div
                        class="icon-btn"><a href="service.html"><i
                                class="fa-regular fa-arrow-up-right"></i></a></div>
                </div>
            </div>
            <div
                class="service-card tg-img-reveal-item" data-fx="1"
                data-img="assets/img/service/service_1_3.jpg" style>
                <div
                    class="service-wrapp">
                    <div class="box-icon"><img
                            src="<?php echo e(asset('assets/img/icon/seo.png')); ?>"
                            alt="Icon"></div>
                    <h3 class="box-title">SEO & Marketing Agencies
                    </h3>
                </div>
                <div
                    class="service-content">
                    <p class="box-text">Partner with us to enhance your clients’ digital presence with proven SEO strategies and results-driven solutions.
                    </p>
                    <div class="icon-btn"><a
                            href="service.html"><i
                                class="fa-regular fa-arrow-up-right"></i></a></div>
                </div>
            </div>
            <div
                class="service-card tg-img-reveal-item" data-fx="1"
                data-img="assets/img/service/service_1_4.jpg" style>
                <div
                    class="service-wrapp">
                    <div class="box-icon"><img
                            src="<?php echo e(asset('assets/img/icon/store.png')); ?>"
                            alt="Icon"></div>
                    <h3 class="box-title">Local Businesses
                    </h3>
                </div>
                <div
                    class="service-content">
                    <p class="box-text">Get found by nearby customers with local SEO, Google Business optimization, and community-focused digital growth.
                    </p>
                    <div class="icon-btn"><a
                            href="service.html"><i
                                class="fa-regular fa-arrow-up-right"></i></a></div>
                </div>


            </div>
            <div
                class="service-card tg-img-reveal-item" data-fx="1"
                data-img="assets/img/service/service_1_4.jpg" style>
                <div
                    class="service-wrapp">
                    <div class="box-icon"><img
                            src="<?php echo e(asset('assets/img/icon/enterprise.png')); ?>"
                            alt="Icon"></div>
                    <h3 class="box-title"> Enterprise SEO Teams
                    </h3>
                </div>
                <div
                    class="service-content">
                    <p class="box-text">Power enterprise growth with advanced SEO strategies, analytics, and scalable solutions for large organizations.
                    </p>
                    <div class="icon-btn"><a
                            href="service.html"><i
                                class="fa-regular fa-arrow-up-right"></i></a></div>
                </div>


            </div>
        </div>
    </div>
</section>




<div
    class="overflow-hidden space" id="about-sec">
    <div
        class="container">
        <div class="row gy-4 flex-row-reverse">
            <div
                class="col-xl-6">
                <div class="title-area mb-35">
                    <!-- <span
                                class="sub-title sub-title6 style1 text-ani-style2">About
                                Us</span> -->
                    <h2
                        class="sec-title sec-title2 text-ani-style3">Pricing That Scales With You

                    </h2>
                </div>
                <p
                    class="mt-n2 mb-30 wow fadeInUp"
                    data-wow-delay=".3s">Flexible packages designed for startups, agencies, and enterprises.

                </p>
                <div
                    class="counter-item-wrap">
                    <div
                        class="checklist style4">
                        <ul>
                            <li
                                class="wow fadeInUp"
                                data-wow-delay=".2s"><i
                                    class="fa-solid fa-shield-check"></i>Pay per link or monthly plans
                            </li>
                            <li
                                class="wow fadeInUp"
                                data-wow-delay=".3s"><i
                                    class="fa-solid fa-shield-check"></i>Custom anchor & URL targeting

                            </li>
                            <li
                                class="wow fadeInUp"
                                data-wow-delay=".4s"><i
                                    class="fa-solid fa-shield-check"></i>Bulk discounts available
                            </li>

                            </li>
                        </ul>
                    </div>
                </div>
                <div
                    class="btn-group about-btn justify-content-start">
                    <h4>Request Pricing (no obligation)</h4>

                </div>
            </div>
            <div
                class="col-xl-6">
                <div class="img-box4">
                    <div
                        class="img1"><img
                            src="<?php echo e(asset('assets/img/shape/shape-19.png')); ?>"
                            alt="About"></div>
                    <div class="img2"><img
                            src="<?php echo e(asset('assets/img/shape/shape-20.png')); ?>"
                            alt="About"></div>
                    <div
                        class="th-experience">
                        <h2
                            class="experience-year"><span
                                class="counter-number">10</span>+</h2>
                        <p
                            class="experience-text">Years of
                            Experiences
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div
    class="brand-sec overflow-hidden bg-smoke2 space-extra2">
    <div
        class="container th-container">
        <div
            class="title-area mb-60 text-center">
            <h3
                class="brand-title2 mt-n3 text-ani-style3">Trusted by Growth-Driven Brands

            </h3>
            <p>Powering rankings for SaaS companies, e-commerce brands, agencies, and local businesses worldwide.
            </p>
            <img
                src="<?php echo e(asset('assets/img/theme-img/title_shape6.svg')); ?>"
                alt>
        </div>
        <div class="slider-area text-center">
            <div
                class="swiper th-slider" id="brandSlider1"
                data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"476":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"6"}}}'>
                <div
                    class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="brand-item style4">
                            <a href="#">
                                <img
                                    class="original"
                                    src="<?php echo e(asset('assets/img/brand/brand_1_1.svg')); ?>"
                                    alt="Brand Logo">

                                <img
                                    class="gray"
                                    src="<?php echo e(asset('assets/img/brand/brand_1_1.svg')); ?>"
                                    alt="Brand Logo"
                                    style="filter: invert(36%) sepia(24%) saturate(1050%) hue-rotate(230deg) brightness(95%);">
                            </a>
                        </div>
                    </div>

                    <div class="swiper-slide">
                        <div class="brand-item style4">
                            <a href="#">
                                <img
                                    class="original"
                                    src="<?php echo e(asset('assets/img/brand/brand_1_2.svg')); ?>"
                                    alt="Brand Logo">

                                <img
                                    class="gray"
                                    src="<?php echo e(asset('assets/img/brand/brand_1_2.svg')); ?>"
                                    alt="Brand Logo"
                                    style="filter: invert(36%) sepia(24%) saturate(1050%) hue-rotate(230deg) brightness(95%);">
                            </a>
                        </div>
                    </div>

                    <div class="swiper-slide">
                        <div class="brand-item style4">
                            <a href="#">
                                <img
                                    class="original"
                                    src="<?php echo e(asset('assets/img/brand/brand_1_3.svg')); ?>"
                                    alt="Brand Logo">

                                <img
                                    class="gray"
                                    src="<?php echo e(asset('assets/img/brand/brand_1_3.svg')); ?>"
                                    alt="Brand Logo"
                                    style="filter: invert(36%) sepia(24%) saturate(1050%) hue-rotate(230deg) brightness(95%);">
                            </a>
                        </div>
                    </div>

                    <div class="swiper-slide">
                        <div class="brand-item style4">
                            <a href="#">
                                <img class="original" src="<?php echo e(asset('assets/img/brand/brand_1_4.svg')); ?>" alt="Brand Logo">
                                <img class="gray" src="<?php echo e(asset('assets/img/brand/brand_1_4.svg')); ?>" alt="Brand Logo"
                                    style="filter: invert(36%) sepia(24%) saturate(1050%) hue-rotate(230deg) brightness(95%);">
                            </a>
                        </div>
                    </div>

                    <div class="swiper-slide">
                        <div class="brand-item style4">
                            <a href="#">
                                <img class="original" src="<?php echo e(asset('assets/img/brand/brand_1_5.svg')); ?>" alt="Brand Logo">
                                <img class="gray" src="<?php echo e(asset('assets/img/brand/brand_1_5.svg')); ?>" alt="Brand Logo"
                                    style="filter: invert(36%) sepia(24%) saturate(1050%) hue-rotate(230deg) brightness(95%);">
                            </a>
                        </div>
                    </div>

                    <div class="swiper-slide">
                        <div class="brand-item style4">
                            <a href="#">
                                <img class="original" src="<?php echo e(asset('assets/img/brand/brand_1_6.svg')); ?>" alt="Brand Logo">
                                <img class="gray" src="<?php echo e(asset('assets/img/brand/brand_1_6.svg')); ?>" alt="Brand Logo"
                                    style="filter: invert(36%) sepia(24%) saturate(1050%) hue-rotate(230deg) brightness(95%);">
                            </a>
                        </div>
                    </div>

                    <div class="swiper-slide">
                        <div class="brand-item style4">
                            <a href="#">
                                <img class="original" src="<?php echo e(asset('assets/img/brand/brand_1_1.svg')); ?>" alt="Brand Logo">
                                <img class="gray" src="<?php echo e(asset('assets/img/brand/brand_1_1.svg')); ?>" alt="Brand Logo"
                                    style="filter: invert(36%) sepia(24%) saturate(1050%) hue-rotate(230deg) brightness(95%);">
                            </a>
                        </div>
                    </div>

                    <div class="swiper-slide">
                        <div class="brand-item style4">
                            <a href="#">
                                <img class="original" src="<?php echo e(asset('assets/img/brand/brand_1_2.svg')); ?>" alt="Brand Logo">
                                <img class="gray" src="<?php echo e(asset('assets/img/brand/brand_1_2.svg')); ?>" alt="Brand Logo"
                                    style="filter: invert(36%) sepia(24%) saturate(1050%) hue-rotate(230deg) brightness(95%);">
                            </a>
                        </div>
                    </div>

                    <!-- <div class="swiper-slide">
                        <div class="brand-item style4">
                            <a href="#">
                                <img class="original" src="<?php echo e(asset('assets/img/brand/brand_1_3.svg')); ?>" alt="Brand Logo"

                                    <img class="gray" src="<?php echo e(asset('assets/img/brand/brand_1_3.svg')); ?>" alt="Brand Logo"
                                    style="filter: invert(36%) sepia(24%) saturate(1050%) hue-rotate(230deg) brightness(95%);">
                            </a>
                        </div>
                    </div>

                    <div class="swiper-slide">
                        <div class="brand-item style4">
                            <a href="#">
                                <img class="original" src="<?php echo e(asset('assets/img/brand/brand_1_4.svg')); ?>" alt="Brand Logo"

                                    <img class="gray" src="<?php echo e(asset('assets/img/brand/brand_1_4.svg')); ?>" alt="Brand Logo"
                                    style="filter: invert(36%) sepia(24%) saturate(1050%) hue-rotate(230deg) brightness(95%);">
                            </a>
                        </div>
                    </div> -->

                    <div class="swiper-slide">
                        <div class="brand-item style4">
                            <a href="#">
                                <img class="original" src="<?php echo e(asset('assets/img/brand/brand_1_5.svg')); ?>" alt="Brand Logo"

                                    <img class="gray" src="<?php echo e(asset('assets/img/brand/brand_1_5.svg')); ?>" alt="Brand Logo">
                            </a>
                        </div>
                    </div>

                    <div class="swiper-slide">
                        <div class="brand-item style4">
                            <a href="#">
                                <img class="original" src="<?php echo e(asset('assets/img/brand/brand_1_6.svg')); ?>" alt="Brand Logo">
                                <img class="gray" src="<?php echo e(asset('assets/img/brand/brand_1_6.svg')); ?>" alt="Brand Logo"
                                    style="filter: invert(36%) sepia(24%) saturate(1050%) hue-rotate(230deg) brightness(95%);">
                            </a>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<div class="counter-area2 overflow-hidden bg-title">
    <div class="container">
        <div class="counter-box2-wrap">
            <div class="counter-box2">
                <h2 class="box-number"><span
                        class="counter-number">3</span>k<span
                        class="plus">+</span></h2>
                <div class="media-body">
                    <p class="box-text mb-n1">Successful Project</p>
                </div>
            </div>
            <div class="divider"></div>
            <div class="counter-box2">
                <h2 class="box-number"><span
                        class="counter-number">500</span>+</h2>
                <div class="media-body">
                    <p class="box-text mb-n1">Experienced Team</p>
                </div>
            </div>
            <div class="divider"></div>
            <div class="counter-box2">
                <h2 class="box-number"><span
                        class="counter-number">8</span>k<span
                        class="plus">+</span></h2>
                <div class="media-body">
                    <p class="box-text mb-n1">Positive Review</p>
                </div>
            </div>
            <div class="divider"></div>
            <div class="counter-box2">
                <h2 class="box-number"><span
                        class="counter-number">16</span>+</h2>
                <div class="media-body">
                    <p class="box-text mb-n1">We’re Wining Awards</p>
                </div>
            </div>
            <div class="divider"></div>
        </div>
    </div>
</div>
<div class="history-sec1 space"
    data-bg-src="<?php echo e(asset('assets/img/bg/history_bg_1.png')); ?>">
    <div
        class="container">
        <div
            class="row gy-5 justify-content-between">
            <div
                class="col-xxl-5">
                <div class="title-area">
                    <span
                        class="sub-title sub-title10 style1 text-ani-style2">
                        How It Works </span>
                    <h2
                        class="sec-title text-ani-style3">Simple. Transparent. Built for Growth.
                    </h2>
                </div>
                <div
                    class="history-image"><img
                        src="<?php echo e(asset('assets/img/normal/history-img.jpg')); ?>"
                        alt></div>
            </div>
            <div class="col-xxl-7">
                <div
                    class="timeline">
                    <div
                        class="containr left-container">
                        <div
                            class="timeline-step">
                            <h3
                                class="box-title">Tell Us Your Goals
                            </h3>
                            <p class="box-text">Share your keywords, niche, and competitors. We analyze everything and plan accordingly.

                            </p>
                        </div>
                    </div>
                    <div
                        class="containr right-container">
                        <div
                            class="timeline-step">
                            <h3
                                class="box-title">We Build the Links

                            </h3>
                            <p
                                class="box-text">Manual outreach to real, niche-relevant publishers for quality backlinks.
                            </p>
                        </div>
                    </div>
                    <div
                        class="containr left-container">
                        <div
                            class="timeline-step">
                            <h3
                                class="box-title">You Track the Results

                            </h3>
                            <p class="box-text">View live links, clear reports, and ranking improvements.

                            </p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <div
        class="shape-mockup z-index-3 d-none d-xxl-block"
        data-bottom="0%" data-right="0%"><img
            src="<?php echo e(asset('assets/img/shape/shape-33.png')); ?>" alt></div>
</div>
<section
    class>
    <div style="padding-top: 50px !important;" class="container">
        <div class="cta-area3"
            data-bg-src="<?php echo e(asset('assets/img/bg/cta_bg_1.png')); ?>">
            <div
                class="cta-image1"><img
                    src="<?php echo e(asset('assets/img/normal/cta-img1.png')); ?>" alt></div>
            <div
                class="title-area mb-0">
                <h3
                    class="sec-title mb-0">Skyrocket Your Traffic with
                    Expert SEO
                </h3>
            </div>
            <div class=""><a
                    href="<?php echo e(route('contact')); ?>"
                    style="background-color: #7D55AA;"
                    class="th-btn th-radius3 th-icon th-black3">
                    Contact us <i class="fa-regular fa-arrow-right ms-2"></i>
                </a>

            </div>
        </div>
    </div>


</section>
<div
    class="positive-relative overflow-hidden space">
    <div
        class="container">
        <div class="title-area text-center">
            <span
                class="sub-title sub-title11 style1 text-ani-style2">Testimonial</span>
            <h2
                class="sec-title text-ani-style3">What Our Clients Say
                About Us
            </h2>
        </div>
        <div class="row gy-4">
            <div
                class="col-xl-4">
                <div class="testimonial-content">
                    <!-- <div
                        class="avatar"><img
                        src="<?php echo e(asset('assets/img/testimonial/avatar.png')); ?>"
                        alt></div> -->
                    <h4 class="box-title">Almost <span
                            class="text-theme">10k+ Member</span> are
                        connected
                    </h4>
                    <a
                        href="<?php echo e(route('contact')); ?>"
                        class="th-btn th-icon">Contact us<i
                            class="fa-regular fa-arrow-right ms-2"></i></a>
                </div>
            </div>
            <div
                class="col-xl-8">
                <div
                    class="swiper th-slider has-shadow testi-slider8"
                    id="testiSlider8"
                    data-slider-options='{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1200":{"slidesPerView":"1"}}}'>
                    <div
                        class="swiper-wrapper">
                        <div
                            class="swiper-slide">
                            <div
                                class="testi-box7">
                                <div
                                    class="box-wrapp">
                                    <div
                                        class="testi-box7_profile">
                                        <div
                                            class="testi-box7_author"><img
                                                src="<?php echo e(asset('assets/img/testimonial/testi_4_1.png')); ?>"
                                                alt="Avater"></div>
                                        <div
                                            class="testi-box7_info">
                                            <h3
                                                class="box-title">SaaS Founder
                                            </h3>
                                            <span
                                                class="testi-box7_desig">Business
                                                Student</span>
                                        </div>
                                    </div>
                                    <div
                                        class="testi-quote"
                                        style="
    width: 40px;
    height: 40px;
    background-color: #5EC8D5;
    -webkit-mask: url('assets/img/icon/quote3.svg') no-repeat center / contain;
    mask: url('assets/img/icon/quote3.svg') no-repeat center / contain;
  ">
                                    </div>

                                </div>
                                <p
                                    class="testi-box7_text">“RankFetch helped us jump from page 3 to top 5 in under 3 months. Clean links, great communication.”
                                </p>
                                <div
                                    class="testi-box7_review"><i
                                        class="fa-solid fa-star"></i> <i
                                        class="fa-solid fa-star"></i> <i
                                        class="fa-solid fa-star"></i> <i
                                        class="fa-solid fa-star"></i> <i
                                        class="fa-solid fa-star"></i></div>
                            </div>
                        </div>
                        <div
                            class="swiper-slide">
                            <div
                                class="testi-box7">
                                <div
                                    class="box-wrapp">
                                    <div
                                        class="testi-box7_profile">
                                        <div
                                            class="testi-box7_author"><img
                                                src="<?php echo e(asset('assets/img/testimonial/testi_4_2.png')); ?>"
                                                alt="Avater"></div>
                                        <div
                                            class="testi-box7_info">
                                            <h3
                                                class="box-title">SEO Agency Owner
                                            </h3>
                                            <span
                                                class="testi-box7_desig">Business
                                                Student</span>
                                        </div>
                                    </div>
                                    <div
                                        class="testi-quote"><img
                                            src="<?php echo e(asset('assets/img/icon/quote3.svg')); ?>"
                                            alt></div>
                                </div>
                                <p
                                    class="testi-box7_text">“Best white-label link building partner we’ve used. Our clients love the results.”
                                </p>
                                <div
                                    class="testi-box7_review"><i
                                        class="fa-solid fa-star"></i> <i
                                        class="fa-solid fa-star"></i> <i
                                        class="fa-solid fa-star"></i> <i
                                        class="fa-solid fa-star"></i> <i
                                        class="fa-solid fa-star"></i></div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<div
    class="bg-smoke2 overflow-hidden space" id="faq-sec">
    <div
        class="container">
        <div class="row gy-4">
            <div
                class="col-xl-6">
                <div class="me-xl-5 pe-xl-3">
                    <div
                        class="title-area text-center text-xl-start">
                        <span
                            class="sub-title sub-title9 style1 text-ani-style2">Why RankFetch</span>
                        <h2
                            class="sec-title text-ani-style3">Built for Rankings, Not Just Links
                        </h2>
                    </div>
                    <div
                        class="faq-wrapp">
                        <div class="faq-image"><img
                                src="https://agencyanalytics.com/_next/image?q=75&url=https%3A%2F%2Fimages.ctfassets.net%2Fdfcvkz6j859j%2F1MEC1Kc2RFOGvh79IM5WIc%2F21cb143513d1cc92a717df20120bd79b%2FSEO-Dashboard-Template-Example.png&w=3840"
                                alt></div>
                        <div class="faq-counter">
                            <div
                                class="th-experience3">
                                <!-- <h2
                                 class="experience-year"><span
                                 class="counter-number">25</span>+</h2> -->
                                <p
                                    class="experience-text">Most link sellers sell URLs. We build authority
                                </p>
                            </div>
                            <div
                                class="content">
                                <h5
                                    class="title">Your rankings stay safe, even after Google updates.

                                </h5>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div
                class="col-xl-6">
                <div class="ps-xl-3 mb-40">

                    <div
                        class="process-item">
                        <span class="box-number" style="color:#00B4FF;
 font-size: 40px;">
                            <i class="fa-solid fa-shield-check"></i>
                        </span>

                        <div
                            class="box-content">
                            <h3
                                class="box-title">Manual outreach by real SEO specialists</h3>

                        </div>
                    </div>
                    <div
                        class="process-item">
                        <span class="box-number" style="color:#00B4FF;
 font-size: 40px;">
                            <i class="fa-solid fa-shield-check"></i>
                        </span>
                        <div
                            class="box-content">
                            <h3
                                class="box-title"> Sites vetted for DR, traffic & spam score</h3>

                        </div>
                    </div>
                    <div
                        class="process-item">
                        <span
                            class="box-number" style="color:#00B4FF;
 font-size: 40px;">
                            <i class="fa-solid fa-shield-check"></i></span>
                        <div
                            class="box-content">
                            <h3
                                class="box-title">Anchors optimized for safety & growth</h3>

                        </div>
                    </div>
                    <div
                        class="process-item">
                        <span class="box-number" style="color:#00B4FF;
 font-size: 40px;">
                            <i class="fa-solid fa-shield-check"></i>
                        </span>
                        <div
                            class="box-content">
                            <h3
                                class="box-title">Transparent reporting with live URLs</h3>

                        </div>
                    </div>
                    <div
                        class="process-item">
                        <span class="box-number" style="color:#00B4FF;
 font-size: 40px;">
                            <i class="fa-solid fa-shield-check"></i>
                        </span>
                        <div
                            class="box-content">
                            <h3
                                class="box-title">No long-term contracts
                            </h3>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div
        class="shape-mockup d-none d-xl-block" data-bottom="0%"
        data-left="0%"><img src="<?php echo e(asset('assets/img/shape/faq-shape.png')); ?>"
            alt></div>
</div>

<section
    class="cta-sec space" data-pos-for=".footer-wrapper"
    data-sec-pos="bottom-half">
    <div class="container">
        <div
            class="cta-area space-extra2 text-center"
            data-bg-src="<?php echo e(asset('assets/img/bg/cta_shape_1.png')); ?>">
            <div
                class="row justify-content-center">
                <div
                    class="col-lg-7">
                    <div
                        class="title-area mb-25 mt-n2 text-center">

                        <h2
                            class="sec-title cta-title text-ani-style3">Ready to Boost Your Rankings?
                        </h2>
                        <p
                            class="cta-text">Stop wasting money on low-quality links.
                            Start building <strong> authority that lasts</strong>.

                        </p>
                        <span
                            class="sub-title2 text-ani-style2">Get Started with RankFetch Today</span>
                    </div>
                    <div
                        class="btn-group wow fadeInUp d-flex justify-content-center flex-wrap"
                        data-wow-delay=".4s">
                        <a href="<?php echo e(route('contact')); ?>"
                            class="th-btn th-icon th-radius">Get Started Now<i
                                class="fa-regular fa-arrow-right ms-2"></i></a>
                    </div>
                </div>
            </div>
        </div>
</section>
<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Rank-fetch\Rank-fetch\resources\views/pages/index.blade.php ENDPATH**/ ?>