<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="breadcumb-wrapper" data-bg-src="<?php echo e(asset('assets/img/bg/breadcumb-bg.jpg')); ?>">
    <div class="container">
        <div class="breadcumb-content">
            <h1 class="breadcumb-title"><?php echo e($blog->title); ?></h1>
            <ul class="breadcumb-menu">
                <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                <li><a href="<?php echo e(route('blog')); ?>">Blog</a></li>
                <li>Details</li>
            </ul>
        </div>
    </div>
</div>

<section class="th-blog-wrapper blog-details space-top space-extra-bottom">
    <div class="container">
        <div class="row">
            <div class="col-xxl-8 col-lg-7">
                <div class="th-blog blog-single">
                    <?php if($blog->image): ?>
                    <div class="blog-img">
                        <img src="<?php echo e(asset($blog->image)); ?>" alt="<?php echo e($blog->title); ?>" style="width: 100%; border-radius: 20px;">
                    </div>
                    <?php endif; ?>
                    <div class="blog-content">
                        <div class="blog-meta">
                            <a href="#"><i class="fa-regular fa-calendar"></i><?php echo e($blog->created_at->format('M d, Y')); ?></a>
                            <a href="#"><i class="fa-regular fa-clock"></i><?php echo e(ceil(str_word_count(strip_tags($blog->content)) / 200)); ?> min read</a>
                            <a href="#"><i class="fa-light fa-tags"></i> SEO & Link Building</a>
                        </div>
                        <h2 class="blog-title"><?php echo e($blog->title); ?></h2>
                        <div class="blog-text mt-4">
                            <?php echo $blog->content; ?>

                        </div>
                    </div>
                    <div class="share-links clearfix">
                        <div class="row justify-content-between">
                            <div class="col-sm-auto">
                                <span class="share-links-title">Tags:</span>
                                <div class="tagcloud">
                                    <a href="#">SEO</a>
                                    <a href="#">Link Building</a>
                                    <a href="#">Marketing</a>
                                </div>
                            </div>
                            <div class="col-sm-auto text-xl-end">
                                <span class="share-links-title">Share:</span>
                                <ul class="social-links">
                                    <li><a href="https://facebook.com/" target="_blank"><i class="fab fa-facebook-f"></i></a></li>
                                    <li><a href="https://twitter.com/" target="_blank"><i class="fab fa-twitter"></i></a></li>
                                    <li><a href="https://linkedin.com/" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-xxl-4 col-lg-5">
                <aside class="sidebar-area">
                    <div class="widget">
                        <h3 class="widget_title">Recent Posts</h3>
                        <div class="recent-post-wrap">
                            <?php $__currentLoopData = \App\Models\Blog::where('id', '!=', $blog->id)->latest()->take(3)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="recent-post">
                                <?php if($recent->image): ?>
                                <div class="media-img">
                                    <a href="<?php echo e(route('user.blog.show', $recent->slug)); ?>">
                                        <img src="<?php echo e(asset($recent->image)); ?>" alt="<?php echo e($recent->title); ?>">
                                    </a>
                                </div>
                                <?php endif; ?>
                                <div class="media-body">
                                    <div class="recent-post-meta">
                                        <a href="#"><i class="fa-sharp fa-solid fa-calendar-days"></i><?php echo e($recent->created_at->format('d M, Y')); ?></a>
                                    </div>
                                    <h4 class="post-title">
                                        <a class="text-inherit" href="<?php echo e(route('user.blog.show', $recent->slug)); ?>"><?php echo e(Str::limit($recent->title, 40)); ?></a>
                                    </h4>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="widget widget_tag_cloud">
                        <h3 class="widget_title">Popular Tags</h3>
                        <div class="tagcloud">
                            <a href="#">Advice</a>
                            <a href="#">Marketing</a>
                            <a href="#">Link Building</a>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Rank-fetch\Rank-fetch\resources\views\pages\blog-details.blade.php ENDPATH**/ ?>