<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard RankFetch</title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <style>
        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background-color: #f3f4f6;
        }
        
        .sidebar-gradient {
            background: linear-gradient(180deg, #1e1b4b 0%, #312e81 100%);
        }
        
        .active-link {
            background: rgba(255, 255, 255, 0.1);
            border-left: 4px solid #818cf8;
            color: white !important;
        }
        
        .glass {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.3);
        }
        
        .stat-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
        }

        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 5px;
        }
        ::-webkit-scrollbar-track {
            background: #f1f1f1;
        }
        ::-webkit-scrollbar-thumb {
            background: #888;
            border-radius: 10px;
        }
        ::-webkit-scrollbar-thumb:hover {
            background: #555;
        }
    </style>
</head>
<body class="antialiased text-gray-800">

    <!-- Mobile Sidebar Backdrop -->
    <div id="sidebar-backdrop" class="fixed inset-0 bg-gray-900/50 z-30 hidden lg:hidden"></div>

    <!-- Sidebar -->
    <aside id="sidebar" class="fixed top-0 left-0 z-40 w-64 h-screen transition-transform -translate-x-full lg:translate-x-0 sidebar-gradient text-gray-300">
        <div class="flex flex-col h-full">
            <!-- Logo Section -->
            <div class="flex items-center justify-center h-20 px-6 border-b border-white/10">
                <a href="<?php echo e(route('admin.notifications')); ?>" class="flex items-center space-x-2">
                    <img src="<?php echo e(asset('assets/img/logo.svg')); ?>" class="h-10 invert brightness-0" alt="Logo">
                </a>
            </div>

            <!-- Navigation Links -->
            <nav class="flex-1 px-4 py-6 overflow-y-auto space-y-1">
                <p class="px-4 text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">Main Menu</p>
                
                <a href="<?php echo e(route('admin.notifications')); ?>" class="flex items-center px-4 py-3 text-sm font-medium rounded-lg transition-colors hover:bg-white/5 hover:text-white <?php echo e(request()->routeIs('admin.notifications') ? 'active-link font-semibold' : ''); ?>">
                    <i class="fa-solid fa-house w-6 text-lg"></i>
                    <span class="ml-3">Dashboard</span>
                </a>

                <!-- Blog Dropdown -->
                <div class="space-y-1">
                    <button onclick="toggleDropdown('blog-menu', 'blog-chevron')" class="flex items-center justify-between w-full px-4 py-3 text-sm font-medium rounded-lg transition-colors hover:bg-white/5 hover:text-white">
                        <div class="flex items-center">
                            <i class="fa-solid fa-newspaper w-6 text-lg"></i>
                            <span class="ml-3">Blog Management</span>
                        </div>
                        <i id="blog-chevron" class="fa-solid fa-chevron-down text-xs transition-transform <?php echo e(request()->routeIs('blog.*') || request()->routeIs('admin.blogs.*') ? 'rotate-180' : ''); ?>"></i>
                    </button>
                    <div id="blog-menu" class="<?php echo e(request()->routeIs('blog.*') || request()->routeIs('admin.blogs.*') ? '' : 'hidden'); ?> pl-10 space-y-1">
                        <a href="<?php echo e(route('blog.view')); ?>" class="block px-4 py-2 text-sm rounded-lg hover:text-white hover:bg-white/5 <?php echo e(request()->routeIs('blog.view') ? 'text-indigo-400 font-semibold' : ''); ?>">
                            <i class="fa-solid fa-list-ul mr-2 text-xs"></i> All Blogs
                        </a>
                        <a href="<?php echo e(route('blog.create')); ?>" class="block px-4 py-2 text-sm rounded-lg hover:text-white hover:bg-white/5 <?php echo e(request()->routeIs('blog.create') ? 'text-indigo-400 font-semibold' : ''); ?>">
                            <i class="fa-solid fa-plus-circle mr-2 text-xs"></i> Add New Blog
                        </a>
                    </div>
                </div>

                <!-- Guest Post Dropdown -->
                <div class="space-y-1">
                    <button onclick="toggleDropdown('listing-menu', 'listing-chevron')" class="flex items-center justify-between w-full px-4 py-3 text-sm font-medium rounded-lg transition-colors hover:bg-white/5 hover:text-white">
                        <div class="flex items-center">
                            <i class="fa-solid fa-list-check w-6 text-lg"></i>
                            <span class="ml-3">Guest Post Management</span>
                        </div>
                        <i id="listing-chevron" class="fa-solid fa-chevron-down text-xs transition-transform <?php echo e(request()->routeIs('admin.listings.*') || request()->routeIs('admin.guest-post-orders') ? 'rotate-180' : ''); ?>"></i>
                    </button>
                    <div id="listing-menu" class="<?php echo e(request()->routeIs('admin.listings.*') || request()->routeIs('admin.guest-post-orders') ? '' : 'hidden'); ?> pl-10 space-y-1">
                        <a href="<?php echo e(route('admin.listings.index')); ?>" class="block px-4 py-2 text-sm rounded-lg hover:text-white hover:bg-white/5 <?php echo e(request()->routeIs('admin.listings.index') ? 'text-indigo-400 font-semibold' : ''); ?>">
                            <i class="fa-solid fa-table mr-2 text-xs"></i> All Websites
                        </a>
                        <a href="<?php echo e(route('admin.listings.create')); ?>" class="block px-4 py-2 text-sm rounded-lg hover:text-white hover:bg-white/5 <?php echo e(request()->routeIs('admin.listings.create') ? 'text-indigo-400 font-semibold' : ''); ?>">
                            <i class="fa-solid fa-plus-circle mr-2 text-xs"></i> Add New Site
                        </a>
                        <a href="<?php echo e(route('admin.guest-post-orders')); ?>" class="block px-4 py-2 text-sm rounded-lg hover:text-white hover:bg-white/5 <?php echo e(request()->routeIs('admin.guest-post-orders') ? 'text-indigo-400 font-semibold' : ''); ?>">
                            <i class="fa-solid fa-box-open mr-2 text-xs"></i> Guest Post Orders
                        </a>
                    </div>
                </div>

                <a href="<?php echo e(route('admin.messages.index')); ?>" class="flex items-center px-4 py-3 text-sm font-medium rounded-lg transition-colors hover:bg-white/5 hover:text-white <?php echo e(request()->routeIs('admin.messages.*') ? 'active-link font-semibold' : ''); ?>">
                    <i class="fa-solid fa-envelope w-6 text-lg"></i>
                    <span class="ml-3">Contact Messages</span>
                </a>

                <a href="<?php echo e(route('admin.orders.index')); ?>" class="flex items-center px-4 py-3 text-sm font-medium rounded-lg transition-colors hover:bg-white/5 hover:text-white <?php echo e(request()->routeIs('admin.orders.*') && !request()->routeIs('admin.guest-post-orders') ? 'active-link font-semibold' : ''); ?>">
                    <i class="fa-solid fa-cart-shopping w-6 text-lg"></i>
                    <span class="ml-3">Service Orders (SEO/Edu)</span>
                </a>

                <div class="pt-6">
                    <p class="px-4 text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">Settings</p>
                    <form action="<?php echo e(route('admin.logout')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="flex items-center w-full px-4 py-3 text-sm font-medium rounded-lg text-red-400 transition-colors hover:bg-red-500/10">
                            <i class="fa-solid fa-right-from-bracket w-6 text-lg"></i>
                            <span class="ml-3">Logout</span>
                        </button>
                    </form>
                </div>
            </nav>

            <!-- Bottom Profile -->
            <div class="p-4 border-t border-white/10">
                <div class="flex items-center p-2 rounded-lg bg-white/5">
                    <div class="w-10 h-10 rounded-full bg-indigo-500 flex items-center justify-center text-white font-bold">
                        <?php echo e(strtoupper(substr(session('admin_username', 'A'), 0, 1))); ?>

                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-white"><?php echo e(session('admin_username', 'Admin')); ?></p>
                        <p class="text-xs text-gray-500">Administrator</p>
                    </div>
                </div>
            </div>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="lg:ml-64 min-h-screen">
        <!-- Top Navbar -->
        <header class="sticky top-0 z-30 flex items-center justify-between h-20 px-6 bg-white border-b border-gray-200">
            <div class="flex items-center">
                <button id="mobile-sidebar-toggle" class="p-2 mr-4 text-gray-600 lg:hidden hover:bg-gray-100 rounded-lg">
                    <i class="fa-solid fa-bars text-xl"></i>
                </button>
               
            </div>

            <div class="flex items-center space-x-4">
                <button class="relative p-2 text-gray-400 hover:text-indigo-600 transition-colors">
                    <i class="fa-solid fa-bell text-xl"></i>
                    <span class="absolute top-2 right-2 w-2 h-2 bg-red-500 rounded-full"></span>
                </button>
                <div class="h-8 w-px bg-gray-200 mx-2"></div>
                <div class="flex items-center space-x-3">
                    <div class="text-right hidden sm:block">
                        <p class="text-sm font-semibold text-gray-900"><?php echo e(session('admin_username', 'Admin')); ?></p>
                        <p class="text-xs text-gray-500">Super Admin</p>
                    </div>
                </div>
            </div>
        </header>

        <!-- Content Area -->
        <div class="p-6 lg:p-10">
            <?php if(Session::has('success')): ?>
                <div class="mb-6 p-4 bg-emerald-50 border border-emerald-200 text-emerald-700 rounded-xl flex items-center shadow-sm animate-fade-in">
                    <i class="fa-solid fa-circle-check mr-3 text-lg"></i>
                    <span class="font-medium"><?php echo e(Session::get('success')); ?></span>
                </div>
            <?php endif; ?>

            <?php if(Session::has('error')): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 text-red-700 rounded-xl flex items-center shadow-sm animate-fade-in">
                    <i class="fa-solid fa-circle-exclamation mr-3 text-lg"></i>
                    <span class="font-medium"><?php echo e(Session::get('error')); ?></span>
                </div>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>

    <script>
        function toggleDropdown(menuId, chevronId) {
            const menu = document.getElementById(menuId);
            const chevron = document.getElementById(chevronId);
            menu.classList.toggle('hidden');
            chevron.classList.toggle('rotate-180');
        }

        // Mobile sidebar toggle
        const sidebar = document.getElementById('sidebar');
        const backdrop = document.getElementById('sidebar-backdrop');
        const toggle = document.getElementById('mobile-sidebar-toggle');

        toggle.addEventListener('click', () => {
            sidebar.classList.toggle('-translate-x-full');
            backdrop.classList.toggle('hidden');
        });

        backdrop.addEventListener('click', () => {
            sidebar.classList.add('-translate-x-full');
            backdrop.classList.add('hidden');
        });
    </script>
</body>
</html>
<?php /**PATH C:\Users\dmin\Downloads\Rank-fetch\Rank-fetch\Rank-fetch\resources\views/admin/layout.blade.php ENDPATH**/ ?>