<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\showBlogController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\GuestPostController;
use App\Http\Controllers\Admin\ListingController;
use Illuminate\Support\Facades\Route;

/* Pages */

Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/about-us', fn() => view('pages.about'))->name('about');
Route::get('/contact-us', fn() => view('pages.contact'))->name('contact');
Route::get('/refund-policy', fn() => view('pages.refund-policy'))->name('refund.policy');


Route::get('blog', [showBlogController::class, 'index'])->name('blog');
Route::get('/blog/{slug}', [showBlogController::class, 'show'])->name('user.blog.show');

Route::post('/contact', [ContactController::class, 'store'])->name('contact.store');

/* Services */
Route::prefix('')->group(function () {
    Route::get('/edu-backlinks/', fn() => view('pages.edu-backlinks'))->name('edu.backlinks');
    Route::get('/niche-edits/', fn() => view('pages.niche-edit'))->name('niche.edits');
    Route::get('/guest-post/', [GuestPostController::class, 'index'])->name('guest.post');
    Route::get('/pr-links/', fn() => view('pages.pr-links'))->name('pr.links');
    Route::get('/seo-techniques/', fn() => view('pages.seo'))->name('seo');
});

// Single Guest Post Product Page
Route::get('/product/{slug}', [GuestPostController::class, 'show'])->name('product.show');

// Admin Login Routes
Route::get('/admin/login', [AdminController::class, 'showLogin'])->name('admin.login');
Route::post('/admin/login', [AdminController::class, 'login'])->name('admin.login.post');

// Admin Panel Routes
Route::middleware(['admin.auth'])->group(function () {
    Route::get('/admin', [AdminController::class, 'index'])->name('admin.notifications');
    Route::post('/admin/logout', [AdminController::class, 'logout'])->name('admin.logout');

    // Blog Management
    Route::get('/view/Blog', [BlogController::class, 'index'])->name('blog.view');
    Route::get('/Add/Blog', [BlogController::class, 'create'])->name('blog.create');
    Route::post('/blog/store', [BlogController::class, 'store'])->name('blog.store');
    Route::get('/blogs/edit/{id}', [BlogController::class, 'edit'])->name('admin.blogs.edit');
    Route::put('/blogs/update/{id}', [BlogController::class, 'update'])->name('admin.blogs.update');
    Route::delete('/blogs/delete/{id}', [BlogController::class, 'destroy'])->name('admin.blogs.delete');

    // Guest Post Inventory (Listings)
    Route::resource('admin/listings', ListingController::class)->names([
        'index' => 'admin.listings.index',
        'create' => 'admin.listings.create',
        'store' => 'admin.listings.store',
        'edit' => 'admin.listings.edit',
        'update' => 'admin.listings.update',
        'destroy' => 'admin.listings.destroy',
    ]);
    // Contact Messages Management
    Route::get('/admin/messages', [AdminController::class, 'messagesIndex'])->name('admin.messages.index');
    Route::post('/admin/messages/{id}/reply', [AdminController::class, 'messagesReply'])->name('admin.messages.reply');
    Route::put('/admin/messages/{id}/complete', [AdminController::class, 'markAsCompleted'])->name('admin.messages.complete');
    Route::delete('/admin/messages/{id}', [AdminController::class, 'messagesDestroy'])->name('admin.messages.destroy');

    // Service Orders Management
    Route::get('/admin/orders', [App\Http\Controllers\ServiceOrderController::class, 'adminIndex'])->name('admin.orders.index');
    Route::get('/admin/guest-post-orders', [App\Http\Controllers\ServiceOrderController::class, 'guestPostOrders'])->name('admin.guest-post-orders');
    Route::get('/admin/orders/{order}', [App\Http\Controllers\ServiceOrderController::class, 'adminShow'])->name('admin.orders.show');
    Route::put('/admin/orders/{order}', [App\Http\Controllers\ServiceOrderController::class, 'adminUpdateStatus'])->name('admin.orders.update');
});

// Service Order Public Routes
Route::match(['get', 'post'], '/order/form', [App\Http\Controllers\ServiceOrderController::class, 'showOrderForm'])->name('service.order.form');
Route::post('/order/process', [App\Http\Controllers\ServiceOrderController::class, 'processOrder'])->name('service.order.process');
Route::get('/order/summary/{id}', [App\Http\Controllers\ServiceOrderController::class, 'orderSummary'])->name('service.order.summary');
