<style>
    :root {
        --rf-teal: #47c1d8;
        --rf-dark: #1e1b4b;
        --rf-purple: #7D55A6;
    }
    .form-card-modal {
        background: #fff;
        padding: 10px;
    }
    .service-badge {
        display: inline-block;
        padding: 6px 14px;
        background: rgba(71, 193, 216, 0.1);
        color: var(--rf-teal);
        border-radius: 30px;
        font-size: 12px;
        font-weight: 700;
        text-transform: uppercase;
        margin-bottom: 20px;
    }
    .form-label {
        font-weight: 600;
        color: var(--rf-dark);
        font-size: 14px;
        margin-bottom: 8px;
    }
    .form-control-custom {
        display: block;
        width: 100%;
        padding: 12px 16px;
        font-size: 14px;
        border: 1px solid #e2e8f0;
        border-radius: 12px;
        background-color: #f8fafc;
    }
    .form-control-custom:focus {
        border-color: var(--rf-teal);
        outline: 0;
        background-color: #fff;
    }
    .price-summary {
        background: var(--rf-dark);
        padding: 20px;
        border-radius: 16px;
        color: #fff;
        margin-top: 30px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    .price-val {
        font-size: 24px;
        font-weight: 700;
    }
    .btn-submit-order {
        width: 100%;
        background: var(--rf-teal);
        color: #fff;
        border: none;
        padding: 16px;
        border-radius: 12px;
        font-weight: 700;
        font-size: 16px;
        margin-top: 20px;
        transition: all 0.3s;
    }
    .btn-submit-order:hover {
        background: #38b0c5;
        transform: translateY(-2px);
    }
</style>

<div class="form-card-modal">
    <div class="text-center">
        <span class="service-badge">{{ $service }} service</span>
        <h1 class="h3 fw-bold mb-2">{{ $plan }}</h1>
        <p class="text-muted small">Please provide the necessary details for your order.</p>
    </div>

    <form id="ajaxOrderForm" action="{{ route('service.order.process') }}" method="POST" enctype="multipart/form-data" class="mt-4">
        @csrf
        <input type="hidden" name="service_type" value="{{ $service }}">
        <input type="hidden" name="plan_name" value="{{ $plan }}">
        <input type="hidden" name="price" value="{{ $price }}">

        <div class="mb-3">
            <label class="form-label">Email Address</label>
            <input type="email" name="customer_email" class="form-control-custom" placeholder="your@email.com" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Target Website URL</label>
            <input type="url" name="target_url" class="form-control-custom" placeholder="https://yourwebsite.com" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Anchor Text / Topic</label>
            <input type="text" name="topic" class="form-control-custom" placeholder="e.g. Best SEO Service" required>
        </div>

        <div class="mb-3">
            <label class="form-label">WhatsApp Number (Optional)</label>
            <input type="text" name="whatsapp_number" class="form-control-custom" placeholder="+123 456 7890">
        </div>

        <div class="mb-4">
            <label class="form-label">Instructions / File (Optional)</label>
            <input type="file" name="article_file" class="form-control-custom">
            <small class="text-muted">PDF, Word, or TXT (Max 5MB)</small>
        </div>

        <div class="price-summary">
            <span class="text-muted small">Total Investment:</span>
            <span class="price-val">${{ number_format($price, 0) }}</span>
        </div>

        <button type="submit" class="btn-submit-order">
            Confirm Order Details <i class="fa-regular fa-arrow-right ms-2"></i>
        </button>
    </form>
</div>
