@include('layouts.header')
@include('layouts.navbar')

<div class="breadcumb-wrapper" data-bg-src="{{ asset('assets/img/bg/breadcumb-bg.jpg') }}">
    <div class="container">
        <div class="breadcumb-content">
            <h1 class="breadcumb-title">Checkout</h1>
            <ul class="breadcumb-menu">
                <li><a href="home-seo-agency.html">Home</a></li>
                <li>Checkout</li>
            </ul>
        </div>
    </div>
</div>

 <div class="th-checkout-wrapper space-top space-extra-bottom">
         <div class="container">
            <div class="woocommerce-form-login-toggle">
               <div class="woocommerce-info">Returning customer? <a href="#" class="showlogin">Click here to login</a>
               </div>
            </div>
            <div class="row">
               <div class="col-12">
                  <form action="#" class="woocommerce-form-login">
                     <div class="form-group"><label>Username or email *</label> <input type="text" class="form-control" placeholder="Username or email">
                     </div>
                     <div class="form-group"><label>Password *</label>
                        <input type="text" class="form-control" placeholder="Password">
                     </div>
                     <div class="form-group">
                        <div class="custom-checkbox"><input type="checkbox" id="remembermylogin">
                           <label for="remembermylogin">Remember Me</label>
                        </div>
                     </div>
                     <div class="form-group">
                        <button type="submit" class="th-btn">Login</button>
                        <p class="fs-xs mt-2 mb-0"><a class="text-reset" href="#">Lost your password?</a>
                        </p>
                     </div>
                  </form>
               </div>
            </div>
            <div class="woocommerce-form-coupon-toggle">
               <div class="woocommerce-info">Have a coupon? <a href="#" class="showcoupon">Click here to enter your code</a>
               </div>
            </div>
            <div class="row">
               <div class="col-12">
                  <form action="#" class="woocommerce-form-coupon">
                     <div class="form-group"><label>Coupon code</label>
                        <input type="text" class="form-control" placeholder="Write your coupon code">
                     </div>
                     <div class="form-group"><button type="submit" class="th-btn">Apply coupon</button>
                     </div>
                  </form>
               </div>
            </div>
            <form action="#" class="woocommerce-checkout mt-40">
               <div class="row">
                  <div class="col-lg-6">
                     <h2 class="h4">Billing Details</h2>
                     <div class="row">
                        <div class="col-12 form-group">
                           <select class="form-select">
                              <option>United Kingdom (UK)</option>
                              <option>United State (US)</option>
                              <option>Equatorial Guinea (GQ)</option>
                              <option>Australia (AU)</option>
                              <option>Germany (DE)</option>
                           </select>
                        </div>
                        <div class="col-md-6 form-group"><input type="text" class="form-control" placeholder="First Name"></div>
                        <div class="col-md-6 form-group"><input type="text" class="form-control" placeholder="Last Name"></div>
                        <div class="col-12 form-group"><input type="text" class="form-control" placeholder="Your Company Name"></div>
                        <div class="col-12 form-group"><input type="text" class="form-control" placeholder="Street Address"> <input type="text" class="form-control" placeholder="Apartment, suite, unit etc. (optional)"></div>
                        <div class="col-12 form-group"><input type="text" class="form-control" placeholder="Town / City"></div>
                        <div class="col-md-6 form-group"><input type="text" class="form-control" placeholder="Country"></div>
                        <div class="col-md-6 form-group"><input type="text" class="form-control" placeholder="Postcode / Zip"></div>
                        
                        <!-- Phone Input Replacement -->
                        <div class="col-12 form-group">
                            <input type="text" class="form-control mb-3" placeholder="Email Address">
                            <label class="form-label fw-bold" style="display:block; margin-bottom: 8px;">WhatsApp Number / Phone</label>
                            <input type="tel" id="mobile_code" class="form-control w-100" placeholder="Phone Number" name="phone">
                        </div>

                        <div class="col-12 form-group"><input type="checkbox" id="accountNewCreate">
                           <label for="accountNewCreate">Creat An Account?</label>
                        </div>
                     </div>
                  </div>
                  <div class="col-lg-6">
                     <p id="ship-to-different-address"><input id="ship-to-different-address-checkbox" type="checkbox" name="ship_to_different_address" value="1" checked="checked"> <label for="ship-to-different-address-checkbox">Ship to a different address? <span class="checkmark"></span></label>
                     </p>
                     <div class="shipping_address">
                        <div class="row">
                           <div class="col-12 form-group">
                              <select class="form-select">
                                 <option>United Kingdom (UK)</option>
                                 <option>United State (US)</option>
                                 <option>Equatorial Guinea (GQ)</option>
                                 <option>Australia (AU)</option>
                                 <option>Germany (DE)</option>
                              </select>
                           </div>
                           <div class="col-md-6 form-group"><input type="text" class="form-control" placeholder="First Name"></div>
                           <div class="col-md-6 form-group"><input type="text" class="form-control" placeholder="Last Name"></div>
                           <div class="col-12 form-group"><input type="text" class="form-control" placeholder="Your Company Name"></div>
                           <div class="col-12 form-group"><input type="text" class="form-control" placeholder="Street Address"> <input type="text" class="form-control" placeholder="Apartment, suite, unit etc. (optional)"></div>
                           <div class="col-12 form-group"><input type="text" class="form-control" placeholder="Town / City"></div>
                           <div class="col-md-6 form-group"><input type="text" class="form-control" placeholder="Country"></div>
                           <div class="col-md-6 form-group"><input type="text" class="form-control" placeholder="Postcode / Zip"></div>
                           <div class="col-12 form-group"><input type="text" class="form-control" placeholder="Email Address"> <input type="text" class="form-control" placeholder="Phone number"></div>
                        </div>
                     </div>
                     <div class="col-12 form-group"><textarea cols="20" rows="5" class="form-control" placeholder="Notes about your order, e.g. special notes for delivery."></textarea></div>
                  </div>
               </div>
            </form>
            <h4 class="mt-4 pt-lg-2">Your Order</h4>
            <form action="#" class="woocommerce-cart-form">
               <table class="cart_table mb-20">
                  <thead>
                     <tr>
                        <th class="cart-col-image">Image</th>
                        <th class="cart-col-productname">Product Name</th>
                        <th class="cart-col-price">Price</th>
                        <th class="cart-col-quantity">Quantity</th>
                        <th class="cart-col-total">Total</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr class="cart_item">
                        <td data-title="Product"><a class="cart-productimage" href="shop-details.html"><img width="91" height="91" src="assets/img/product/product_1_1.jpg" alt="Image"></a></td>
                        <td data-title="Name"><a class="cart-productname" href="shop-details.html">red sony gaming headsets</a>
                        </td>
                        <td data-title="Price"><span class="amount"><bdi><span>$</span>18</bdi></span></td>
                        <td data-title="Quantity"><strong class="product-quantity">01</strong></td>
                        <td data-title="Total"><span class="amount"><bdi><span>$</span>18</bdi></span></td>
                     </tr>
                  </tbody>
                  <tfoot class="checkout-ordertable">
                     <tr class="cart-subtotal">
                        <th>Subtotal</th>
                        <td data-title="Subtotal" colspan="4"><span class="woocommerce-Price-amount amount"><bdi><span class="woocommerce-Price-currencySymbol">$</span>281.05</bdi></span></td>
                     </tr>
                     <tr class="woocommerce-shipping-totals shipping">
                        <th>Shipping</th>
                        <td data-title="Shipping" colspan="4">Enter your address to view shipping options.
                        </td>
                     </tr>
                     <tr class="order-total">
                        <th>Total</th>
                        <td data-title="Total" colspan="4"><strong><span class="woocommerce-Price-amount amount"><bdi><span class="woocommerce-Price-currencySymbol">$</span>281.05</bdi></span></strong></td>
                     </tr>
                  </tfoot>
               </table>
            </form>
            <div class="mt-lg-3 mb-30">
               <div class="woocommerce-checkout-payment">
                  
                  <!-- Payment Methods Grid Replacement -->
                   <div class="payment-methods-grid">
                       <div class="payment-card active" onclick="selectPayment(this, 'bacs')">
                           <input type="radio" name="payment_method" value="bacs" checked class="d-none">
                           <div class="card-content">
                               <span class="icon"><i class="fas fa-university"></i></span>
                               <span class="title">Direct Bank Transfer</span>
                           </div>
                       </div>
                       <div class="payment-card" onclick="selectPayment(this, 'cheque')">
                           <input type="radio" name="payment_method" value="cheque" class="d-none">
                           <div class="card-content">
                               <span class="icon"><i class="fas fa-money-check-alt"></i></span>
                               <span class="title">Cheque Payment</span>
                           </div>
                       </div>
                       <div class="payment-card" onclick="selectPayment(this, 'cod')">
                           <input type="radio" name="payment_method" value="cod" class="d-none">
                           <div class="card-content">
                               <span class="icon"><i class="fas fa-credit-card"></i></span>
                               <span class="title">Credit Card</span>
                           </div>
                       </div>
                       <div class="payment-card" onclick="selectPayment(this, 'paypal')">
                           <input type="radio" name="payment_method" value="paypal" class="d-none">
                           <div class="card-content">
                               <span class="icon"><i class="fab fa-paypal"></i></span>
                               <span class="title">Paypal</span>
                           </div>
                       </div>
                   </div>
                   <div class="payment-descriptions mt-3 mb-4">
                       <div id="desc_bacs" class="payment-desc">Make your payment directly into our bank account. Please use your Order ID as the payment reference. Your order will not be shipped until the funds have cleared in our account.</div>
                       <div id="desc_cheque" class="payment-desc d-none">Please send a check to Store Name, Store Street, Store Town, Store State / County, Store Postcode.</div>
                       <div id="desc_cod" class="payment-desc d-none">Pay with cash upon delivery.</div>
                       <div id="desc_paypal" class="payment-desc d-none">Pay via PayPal; you can pay with your credit card if you don’t have a PayPal account.</div>
                   </div>

                  <div class="form-row place-order"><button type="submit" class="th-btn">Place order</button>
                  </div>
               </div>
            </div>
         </div>
      </div>

@push('styles')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
<style>
    /* Phone Input Styles */
    .iti { width: 100%; display: block; }
    
    /* Payment Methods Grid */
    .payment-methods-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(130px, 1fr));
        gap: 15px;
        margin-bottom: 20px;
    }
    .payment-card {
        border: 2px solid #eee;
        padding: 15px;
        border-radius: 12px;
        cursor: pointer;
        transition: all 0.3s ease;
        text-align: center;
        background: #fff;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        min-height: 120px;
    }
    .payment-card:hover {
        border-color: #0d6efd; /* Theme color fallback */
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    }
    .payment-card.active {
        border-color: #0d6efd;
        background: #f0f7ff;
        box-shadow: 0 4px 12px rgba(13, 110, 253, 0.15);
    }
    .payment-card .icon {
        font-size: 28px;
        color: #0d6efd;
        margin-bottom: 10px;
        display: inline-block;
    }
    .payment-card .title {
        font-weight: 600;
        color: #333;
        font-size: 13px;
        line-height: 1.4;
    }
    .payment-desc {
        background: #f8f9fa;
        padding: 15px;
        border-radius: 8px;
        border-left: 4px solid #0d6efd;
        font-size: 14px;
        color: #555;
        animation: fadeIn 0.3s ease-in-out;
        margin-bottom: 20px;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(5px); }
        to { opacity: 1; transform: translateY(0); }
    }
</style>
@endpush

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Phone Input Initialization
        var input = document.querySelector("#mobile_code");
        if(input) {
            window.intlTelInput(input, {
                initialCountry: "pk",
                separateDialCode: true,
                utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js"
            });
        }

        // Payment Method Selection Logic
        window.selectPayment = function(element, method) {
            // Update UI
            document.querySelectorAll('.payment-card').forEach(card => card.classList.remove('active'));
            element.classList.add('active');
            
            // Checking the radio button
            const radio = element.querySelector('input[type="radio"]');
            if(radio) radio.checked = true;
            
            // Show Description
            document.querySelectorAll('.payment-desc').forEach(desc => desc.classList.add('d-none'));
            const desc = document.getElementById('desc_' + method);
            if(desc) desc.classList.remove('d-none');
        }
        
        // Initialize default payment selection
        const defaultPayment = document.querySelector('input[name="payment_method"]:checked');
        if(defaultPayment) {
            const card = defaultPayment.closest('.payment-card');
            if(card) {
                card.classList.add('active');
                const method = defaultPayment.value;
                const desc = document.getElementById('desc_' + method);
                if(desc) desc.classList.remove('d-none');
            }
        }
    });
</script>
@endpush

@include('layouts.footer')