@section('title', 'Refund & Returns Policy | RankFetch')
@section('meta_description', 'Read the Refund & Returns Policy for RankFetch. We strive to provide high-quality SEO and link building services.')

@include('layouts.header')
@include('layouts.navbar')

<div class="breadcumb-wrapper" data-bg-src="{{ asset('assets/img/bg/breadcumb-bg.jpg') }}">
    <div class="container">
        <div class="breadcumb-content">
            <h1 class="breadcumb-title">Refund & Returns Policy</h1>
            <ul class="breadcumb-menu">
                <li><a href="{{ route('home') }}">Home</a></li>
                <li>Refund Policy</li>
            </ul>
        </div>
    </div>
</div>

<section class="space">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="rf-clean-policy">
                    <div class="title-area text-center mb-50">

                        <h2 class="sec-title">Refund & Returns Policy</h2>
                        <div class="rf-line mx-auto mt-20"></div>
                    </div>

                    <div class="rf-policy-content">
                        <p class="intro-text mb-40">Thank you for choosing <strong>RankFetch</strong>. We strive to provide high-quality SEO and link building services that help you grow. However, if you are not entirely satisfied with your purchase, we’re here to help. <br> Please read this Refund Policy carefully to understand your rights and options.</p>

                        <!-- Section 1 -->
                        <div class="rf-section mb-50">
                            <h3 class="rf-h3"> Eligibility for Refund</h3>
                            <p class="rf-p">Refund requests may be considered under the following conditions:</p>

                            <div class="mb-20">
                                <h5 class="rf-h5">Service Not Delivered</h5>
                                <p class="rf-p">If we fail to start or complete the service within the agreed timeframe.</p>
                            </div>
                            <div>
                                <h5 class="rf-h5"> Material Service Errors</h5>
                                <p class="rf-p">If there was an error in service delivery that we cannot fix within a reasonable period.</p>
                            </div>
                        </div>
                        <blockquote>
                            <p>Refunds will not be issued for services that were:
                            <ul class="rf-p">
                                <li>Partially delivered</li>
                                <li>Fully delivered as agreed</li>
                                <li>Declined changes due to customer preference</li>
                                <li>Affected by customer-provided guidelines</li>
                            </ul>
                            </p>
                        </blockquote>
                        <!-- </div> -->

                        <!-- Section 2 -->
                        <div class="rf-section mb-50">
                            <h3 class="rf-h3">Non-Refundable Services</h3>
                            <p style="color: #000000;">Certain services are not eligible for refunds, including:</p>
                            <ul class="rf-p">
                                <li>Completed SEO campaigns</li>
                                <li>Delivered backlinks (live URLs)</li>
                                <li>Guest posts and niche edits</li>
                                <li>Links placed or published</li>
                                <li>SEO consulting hours already used</li>
                                <li>Customized and executed services</li>
                            </ul>
                            <blockquote>
                                <p class="rf-p">Once content is published and live, refund requests cannot be accepted.
                                </p>
                            </blockquote>
                        </div>

                        <div class="rf-section mb-50">
                            <h3 class="rf-h3"> How to Request a Refund</h3>
                            <p class="rf-p">To request a refund, please contact our support team at:</p>
                            <p class="rf-p"><strong>Email:</strong> <a href="mailto:support@rankfetch.com" class="text-theme">support@rankfetch.com</a>
                            <p class="rf-p"><strong>Subject:</strong> “Refund Request – Order #[Order Number]”</p>

                            <blockquote>
                                <p class="rf-p">Be sure to include:</p>
                                <ul class="rf-p">
                                    <li>Full name</li>
                                    <li>Order number</li>
                                    <li>Reason for refund request</li>
                                    <li>Supporting evidence (screenshots, communication, etc.)</li>
                                </ul>

                            </blockquote>

                        </div>

                        <div class="rf-section mb-50">
                            <h3 class="rf-h3">Refund Review & Approval</h3>
                            <p class="rf-p">RankFetch will review your refund request and determine whether you qualify based on:</p>
                            <ul class="rf-p">
                                <li>
                                    Service agreement terms

                                </li>
                                <li>Evidence provided</li>
                                <li>Service status and delivery logs</li>
                            </ul>

                            <blockquote>
                                <p class="rf-p">If approved, refunds will be issued via your original payment method within 7 business days after approval.</p>


                            </blockquote>

                        </div>

                        <div class="rf-section mb-50">
                            <h3 class="rf-h3">Partial Refunds</h3>
                            <p class="rf-p">In some cases, we may offer a partial refund when:</p>
                            <ul class="rf-p">
                                <li>
                                    Part of the service was delivered properly


                                </li>
                                <li>The issue affected only a portion of the order</li>
                                <li>A compromise is deemed fair during review</li>
                            </ul>

                            <blockquote>
                                <p class="rf-p">RankFetch reserves the right to determine partial refund amounts.</p>


                            </blockquote>

                        </div>

                        <!-- Section 1 -->
                        <div class="rf-section mb-50">
                            <h3 class="rf-h3"> Cancellations</h3>


                            <div class="mb-20">
                                <h5 class="rf-h5">Before Service Begins</h5>
                                <p class="rf-p">You may cancel your order and request a full refund before work begins.</p>
                            </div>
                            <div>
                                <h5 class="rf-h5">After Service Begins</h5>
                                <p class="rf-p">Cancellations may be accepted, but refunds will be prorated based on work already performed.</p>
                            </div>
                        </div>
                        <blockquote>
                            <p class="rf-p">Work is considered “begun” when:
                            <ul class="rf-p">
                                <li>Backlinks are being outreached</li>
                                <li>Content orders have been submitted</li>
                                <li>SEO plans or audits are underway</li>

                            </ul>
                            </p>
                        </blockquote>
                    </div>

                    <div class="rf-section mb-50">
                        <h3 class="rf-h3"> Exceptions</h3>
                        <p class="rf-p">Refunds do not cover:
                        </p>
                        <ul class="rf-p">
                            <li>
                                Losses due to search engine algorithm changes


                            </li>
                            <li>Ranking fluctuations caused by external factors</li>
                            <li>Results not guaranteed by RankFetch</li>
                            <li>Performance metrics that vary over time</li>
                        </ul>

                        <blockquote>
                            <p class="rf-p">SEO outcomes are influenced by multiple factors and cannot be guaranteed as part of the refund.</p>


                        </blockquote>

                    </div>
                    <div class="rf-section mb-50">
                        <h3 class="rf-h3"> Disputes
                        </h3>
                        <p class="rf-p">If a dispute arises, RankFetch will work with the customer in good faith to resolve it.
                            Contact us first before initiating chargebacks or claims with your payment provider.

                        </p>


                    </div>
                    <div class="rf-section mb-50">
                        <h3 class="rf-h3">Changes to This Policy</h3>

                        <ul class="rf-p">
                            <li>
                                RankFetch may update this refund policy at any time.
                            </li>
                            <li>We will post the revised version on our website with a new “Last updated” date.</li>

                        </ul>



                    </div>

                    <div class="rf-section mb-50">
                        <h3 class="rf-h3"> Contact Us</h3>
                        <p class="rf-p">If you have any questions about this policy, please contact</p>
                        <p class="rf-p"><strong>📧 support@rankfetch.com
                            </strong>
                        <p class="rf-p"><strong>🌐 www.rankfetch.com
                            </strong> </p>



                    </div>

                </div>
            </div>
        </div>
    </div>
    </div>
</section>

@include('layouts.footer')

<style>
    /* Clean & Simple Policy Design */
    .rf-clean-policy {
        background: #fff;
        padding: 50px;
        border-radius: 20px;
        border: 1px solid var(--th-border-color);
        box-shadow: 0 5px 30px rgba(0, 0, 0, 0.03);
    }

    .rf-line {
        width: 60px;
        height: 3px;
        background: var(--theme-color);
        border-radius: 10px;
    }

    .intro-text {
        font-size: 18px;
        line-height: 1.6;
        color: black;
    }

    .rf-h3 {
        font-size: 32px;
        font-weight: 800;
        margin-bottom: 20px;
        color: black;
        position: relative;
        padding-left: 15px;
    }

    .rf-h3::before {
        content: '';
        position: absolute;
        left: 0;
        top: 50%;
        transform: translateY(-50%);
        width: 5px;
        height: 24px;
        background: var(--theme-color2);
        border-radius: 10px;
    }

    .rf-h5 {
        font-size: 20px;
        font-weight: 600;
        margin-bottom: 10px;
        color: var(--theme-color);
    }

    .rf-p {
        font-size: 18px;
        margin-bottom: 20px;
        color: black;
        position: relative;
        /* padding-left: 15px; */
    }
    .rf-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .rf-list li {
        margin-bottom: 12px;
        padding-left: 25px;
        position: relative;
        color: black;
    }

    .rf-list li::before {
        content: '\f058';
        font-family: 'Font Awesome 6 Pro';
        position: absolute;
        left: 0;
        top: 2px;
        color: var(--theme-color2);
        font-weight: 900;
    }

    .rf-grid-list {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 10px;
    }

    .rf-note {
        padding: 20px;
        background: var(--smoke-color4);
        border-radius: 10px;
        font-size: 15px;
        border: 1px dashed var(--theme-color);
    }

    @media (max-width: 767px) {
        .rf-clean-policy {
            padding: 30px 20px;
        }

        .rf-grid-list {
            grid-template-columns: 1fr;
        }
    }
</style>