@include('layouts.header')
@include('layouts.navbar')

<div class="breadcumb-wrapper" data-bg-src="{{ asset('assets/img/bg/breadcumb-bg.jpg') }}">
    <div class="container">
        <div class="breadcumb-content">
            <h1 class="breadcumb-title">Blog</h1>
            <ul class="breadcumb-menu">
                <li><a href="{{ route('home') }}">Home</a></li>
                <li>Blog</li>
            </ul>
        </div>
    </div>
</div>

<section class="th-blog-wrapper space-top space-extra-bottom">
    <div class="container">
        <div class="row">
            <div class="col-xxl-8 col-lg-7">
                @forelse($blogs as $blog)
                <div class="th-blog blog-single has-post-thumbnail">
                    @if($blog->image)
                    <div class="blog-img">
                        <a href="{{ route('user.blog.show', $blog->slug) }}">
                            <img src="{{ asset($blog->image) }}" alt="{{ $blog->title }}" style="width: 100%; max-height: 450px; object-cover: cover;">
                        </a>
                    </div>
                    @endif
                    <div class="blog-content">
                        <div class="blog-meta">
                            <a href="#"><i class="fa-light fa-calendar"></i>{{ $blog->created_at->format('M d, Y') }}</a>
                            <a href="#"><i class="fa-regular fa-clock"></i>{{ ceil(str_word_count(strip_tags($blog->content)) / 200) }} min read</a>
                            <a href="#"><i class="fa-light fa-tags"></i> 
                                @if($blog->tags)
                                    @php
                                        $blogTags = array_map('trim', explode(',', $blog->tags));
                                    @endphp
                                    {{ implode(', ', array_slice($blogTags, 0, 2)) }}
                                @else
                                    SEO & Link Building
                                @endif
                            </a>
                        </div>
                        <h3 class="blog-title">
                            <a href="{{ route('user.blog.show', $blog->slug) }}">{{ $blog->title }}</a>
                        </h3>
                        <p class="blog-text">
                            {!! Str::limit(strip_tags($blog->content), 200) !!}
                        </p>
                        <a href="{{ route('user.blog.show', $blog->slug) }}" class="th-btn black-border th-icon th-radius">
                            Read More<i class="fa-regular fa-arrow-right ms-2"></i>
                        </a>
                    </div>
                </div>
                @empty
                <div class="text-center py-5">
                    <h3 class="text-muted">No blogs found.</h3>
                    <p>Check back later for new content!</p>
                </div>
                @endforelse

                <div class="th-pagination">
                    {{ $blogs->links('pagination::bootstrap-5') }}
                </div>
            </div>

            <div class="col-xxl-4 col-lg-5">
                <aside class="sidebar-area">
                    <div class="widget">
                        <h3 class="widget_title">Recent Posts</h3>
                        <div class="recent-post-wrap">
                            @foreach(\App\Models\Blog::latest()->take(3)->get() as $recent)
                            <div class="recent-post">
                                @if($recent->image)
                                <div class="media-img">
                                    <a href="{{ route('user.blog.show', $recent->slug) }}">
                                        <img src="{{ asset($recent->image) }}" alt="{{ $recent->title }}">
                                    </a>
                                </div>
                                @endif
                                <div class="media-body">
                                    <div class="recent-post-meta">
                                        <a href="#"><i class="fa-sharp fa-solid fa-calendar-days"></i>{{ $recent->created_at->format('d M, Y') }}</a>
                                    </div>
                                    <h4 class="post-title">
                                        <a class="text-inherit" href="{{ route('user.blog.show', $recent->slug) }}">{{ Str::limit($recent->title, 40) }}</a>
                                    </h4>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="widget widget_tag_cloud">
                        <h3 class="widget_title">Popular Tags</h3>
                        <div class="tagcloud">
                            @forelse($popularTags as $tag)
                                <a href="{{ route('blog') }}?tag={{ urlencode($tag) }}">{{ $tag }}</a>
                            @empty
                                <a href="#">SEO Marketing</a>
                                <a href="#">Design</a>
                                <a href="#">Link Building</a>
                            @endforelse
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

@include('layouts.footer')