<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Reply from RankFetch</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.7;
            color: #2d3748;
            background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
            margin: 0;
            padding: 0;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }
        .email-wrapper {
            width: 100%;
            padding: 40px 20px;
            background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
        }
        .email-container {
            max-width: 650px;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 50px 40px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        .header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            animation: pulse 15s ease-in-out infinite;
        }
        @keyframes pulse {
            0%, 100% { transform: scale(1); opacity: 0.5; }
            50% { transform: scale(1.1); opacity: 0.8; }
        }
        .header-content {
            position: relative;
            z-index: 1;
        }
        .logo {
            font-size: 32px;
            font-weight: 700;
            margin: 0 0 10px 0;
            letter-spacing: -0.5px;
            text-shadow: 0 2px 10px rgba(0,0,0,0.2);
        }
        .tagline {
            font-size: 15px;
            opacity: 0.95;
            font-weight: 400;
            margin: 0;
            letter-spacing: 0.3px;
        }
        .content {
            padding: 45px 40px;
        }
        .greeting {
            font-size: 22px;
            font-weight: 600;
            color: #1a202c;
            margin-bottom: 25px;
            line-height: 1.4;
        }
        .intro-text {
            font-size: 16px;
            color: #4a5568;
            margin-bottom: 30px;
            line-height: 1.7;
        }
        .section-title {
            font-size: 13px;
            font-weight: 700;
            color: #667eea;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
        }
        .section-title::before {
            content: '';
            width: 4px;
            height: 18px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            margin-right: 10px;
            border-radius: 2px;
        }
        .reply-box {
            background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
            border: 2px solid #e2e8f0;
            border-left: 5px solid #667eea;
            padding: 25px;
            margin: 25px 0;
            border-radius: 12px;
            font-size: 16px;
            color: #2d3748;
            line-height: 1.8;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.08);
        }
        .original-message {
            background: #ffffff;
            border: 2px solid #e2e8f0;
            padding: 25px;
            margin: 30px 0;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        .original-message-header {
            font-size: 12px;
            font-weight: 700;
            color: #718096;
            text-transform: uppercase;
            letter-spacing: 0.8px;
            margin-bottom: 15px;
            padding-bottom: 12px;
            border-bottom: 2px solid #e2e8f0;
        }
        .message-meta {
            margin-bottom: 15px;
        }
        .message-meta strong {
            color: #4a5568;
            font-weight: 600;
            display: inline-block;
            min-width: 80px;
        }
        .message-meta span {
            color: #2d3748;
        }
        .message-text {
            background: #f7fafc;
            padding: 18px;
            border-radius: 8px;
            color: #4a5568;
            font-size: 15px;
            line-height: 1.7;
            margin-top: 12px;
        }
        .cta-section {
            text-align: center;
            margin: 35px 0 25px 0;
        }
        .cta-button {
            display: inline-block;
            padding: 16px 40px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 50px;
            font-weight: 600;
            font-size: 15px;
            letter-spacing: 0.3px;
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
            transition: all 0.3s ease;
        }
        .cta-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 15px 40px rgba(102, 126, 234, 0.4);
        }
        .footer {
            background: #f7fafc;
            padding: 35px 40px;
            text-align: center;
            border-top: 1px solid #e2e8f0;
        }
        .footer-text {
            font-size: 13px;
            color: #718096;
            margin: 8px 0;
            line-height: 1.6;
        }
        .footer-brand {
            font-weight: 700;
            color: #667eea;
        }
        .divider {
            height: 1px;
            background: linear-gradient(90deg, transparent 0%, #e2e8f0 50%, transparent 100%);
            margin: 25px 0;
        }
        @media only screen and (max-width: 600px) {
            .email-wrapper {
                padding: 20px 10px;
            }
            .header {
                padding: 35px 25px;
            }
            .content {
                padding: 30px 25px;
            }
            .footer {
                padding: 25px 20px;
            }
            .logo {
                font-size: 26px;
            }
            .greeting {
                font-size: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="email-container">
            <!-- Header -->
            <div class="header">
                <div class="header-content">
                    <h1 class="logo">RankFetch</h1>
                    <p class="tagline">High-Authority SEO Links & Link Building Services</p>
                </div>
            </div>
            
            <!-- Content -->
            <div class="content">
                <p class="greeting">Hello {{ $contact->first_name }} {{ $contact->last_name }},</p>
                
                <p class="intro-text">Thank you for reaching out to us! We've carefully reviewed your message and are pleased to provide you with the following response:</p>
                
                <div class="section-title">Our Response</div>
                <div class="reply-box">
                    {!! nl2br(e($replyMessage)) !!}
                </div>
                
                <div class="divider"></div>
                
                <div class="original-message">
                    <div class="original-message-header">Your Original Message</div>
                    <div class="message-meta">
                        <strong>Subject:</strong> <span>{{ $contact->subject ?? 'N/A' }}</span>
                    </div>
                    <div class="message-meta">
                        <strong>Message:</strong>
                    </div>
                    <div class="message-text">{{ $contact->message }}</div>
                </div>
                
                <p class="intro-text">If you have any additional questions or need further assistance, please don't hesitate to reply to this email. Our team is here to help you succeed!</p>
                
                <div class="cta-section">
                    <a href="{{ url('/') }}" class="cta-button">Visit Our Website</a>
                </div>
            </div>
            
            <!-- Footer -->
            <div class="footer">
                <p class="footer-text"><span class="footer-brand">© {{ date('Y') }} RankFetch</span> - All rights reserved.</p>
                <p class="footer-text">This email was sent in response to your inquiry on our website.</p>
                <p class="footer-text" style="margin-top: 15px; font-size: 12px;">Need help? Contact us anytime at <a href="mailto:{{ env('ADMIN_EMAIL', 'zainabmemon061@gmail.com') }}" style="color: #667eea; text-decoration: none;">{{ env('ADMIN_EMAIL', 'zainabmemon061@gmail.com') }}</a></p>
            </div>
        </div>
    </div>
</body>
</html>
