@extends('admin.layout')

@section('content')
<div class="mb-8 flex justify-between items-center">
    <div>
        <h1 class="text-3xl font-bold text-gray-900">{{ isset($isGuestPostFilter) ? 'Guest Post Orders' : 'Service Orders' }}</h1>
        <p class="text-gray-600 mt-1">{{ isset($isGuestPostFilter) ? 'Manage specifically guest post placement orders.' : 'Manage orders from SEO, Edu, and Niche edit services.' }}</p>
    </div>
</div>

<div class="glass rounded-2xl shadow-sm border border-gray-200 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full text-left border-collapse">
            <thead>
                <tr class="bg-gray-50 border-b border-gray-200">
                    <th class="px-6 py-4 text-sm font-semibold text-gray-700">Order ID</th>
                    <th class="px-6 py-4 text-sm font-semibold text-gray-700">Customer</th>
                    <th class="px-6 py-4 text-sm font-semibold text-gray-700">Service/Plan</th>
                    <th class="px-6 py-4 text-sm font-semibold text-gray-700">Price</th>
                    <th class="px-6 py-4 text-sm font-semibold text-gray-700">Status</th>
                    <th class="px-6 py-4 text-sm font-semibold text-gray-700 text-right">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                @forelse($orders as $order)
                <tr class="hover:bg-gray-50/50 transition-colors">
                    <td class="px-6 py-4 font-medium text-indigo-600">
                        #RF-{{ str_pad($order->id, 5, '0', STR_PAD_LEFT) }}
                    </td>
                    <td class="px-6 py-4">
                        <div class="text-sm font-medium text-gray-900">{{ $order->customer_email }}</div>
                        <div class="text-xs text-gray-500">{{ $order->created_at->format('M d, Y') }}</div>
                    </td>
                    <td class="px-6 py-4">
                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-blue-50 text-blue-700 uppercase mb-1">
                            {{ $order->service_type }}
                        </span>
                        <div class="text-sm text-gray-700">{{ $order->plan_name }}</div>
                    </td>
                    <td class="px-6 py-4 text-sm font-bold text-gray-900">
                        ${{ number_format($order->price, 0) }}
                    </td>
                    <td class="px-6 py-4">
                        <div class="flex flex-col gap-1">
                            @php
                                $orderStatusClasses = [
                                    'new' => 'bg-blue-100 text-blue-800',
                                    'processing' => 'bg-yellow-100 text-yellow-800',
                                    'completed' => 'bg-green-100 text-green-800',
                                    'cancelled' => 'bg-red-100 text-red-800',
                                ];
                                $paymentStatusClasses = [
                                    'pending' => 'bg-gray-100 text-gray-800',
                                    'completed' => 'bg-green-100 text-green-800',
                                    'failed' => 'bg-red-100 text-red-800',
                                ];
                            @endphp
                            <span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $orderStatusClasses[$order->order_status] ?? 'bg-gray-100 text-gray-800' }}">
                                Order: {{ ucfirst($order->order_status) }}
                            </span>
                            <span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $paymentStatusClasses[$order->payment_status] ?? 'bg-gray-100 text-gray-800' }}">
                                Paid: {{ ucfirst($order->payment_status) }}
                            </span>
                        </div>
                    </td>
                    <td class="px-6 py-4 text-right">
                        <a href="{{ route('admin.orders.show', $order->id) }}" class="inline-flex items-center px-3 py-1.5 bg-indigo-50 text-indigo-600 rounded-lg hover:bg-indigo-100 transition-colors text-sm font-medium">
                            <i class="fa-solid fa-eye mr-2"></i> Details
                        </a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="px-6 py-12 text-center text-gray-500">
                        <i class="fa-solid fa-box-open text-4xl mb-4 block"></i>
                        No orders found yet.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @if($orders->hasPages())
    <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
        {{ $orders->links() }}
    </div>
    @endif
</div>
@endsection
