@extends('admin.layout')

@section('content')
<div class="flex flex-col md:flex-row md:items-center md:justify-between mb-8 gap-4">
    <div>
        <h1 class="text-3xl font-bold text-gray-900">Guest Post Inventory</h1>
        <p class="text-gray-600 mt-1">Manage all websites available for guest posting.</p>
    </div>
    <a href="{{ route('admin.listings.create') }}" class="inline-flex items-center px-5 py-2.5 bg-indigo-600 hover:bg-indigo-700 text-white font-medium rounded-xl transition-all shadow-sm shadow-indigo-200">
        <i class="fa-solid fa-plus mr-2"></i>
        Add New Website
    </a>
</div>

<div class="glass rounded-2xl overflow-hidden shadow-sm border border-gray-200">
    <div class="overflow-x-auto">
        <table class="w-full text-left border-collapse">
            <thead>
                <tr class="bg-gray-50/50 border-b border-gray-200 text-gray-500 text-xs uppercase tracking-wider font-semibold">
                    <th class="px-6 py-4">Website</th>
                    <th class="px-6 py-4">Metrics (DA/DR)</th>
                    <th class="px-6 py-4">Traffic</th>
                    <th class="px-6 py-4">Price</th>
                    <th class="px-6 py-4">Type</th>
                    <th class="px-6 py-4 text-right">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200 text-sm">
                @forelse($listings as $listing)
                <tr class="hover:bg-gray-50/50 transition-colors group">
                    <td class="px-6 py-4">
                        <div class="flex flex-col">
                            <span class="font-bold text-gray-900">{{ $listing->title }}</span>
                            <span class="text-xs text-gray-500">{{ $listing->url ?? 'No URL' }}</span>
                            <span class="text-[10px] text-indigo-500 font-medium uppercase mt-0.5">{{ $listing->category }}</span>
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <div class="flex items-center space-x-3">
                            <div class="flex flex-col">
                                <span class="text-xs text-gray-400 font-medium">DA</span>
                                <span class="font-semibold text-gray-700">{{ $listing->da }}</span>
                            </div>
                            <div class="w-px h-6 bg-gray-200"></div>
                            <div class="flex flex-col">
                                <span class="text-xs text-gray-400 font-medium">DR</span>
                                <span class="font-semibold text-gray-700">{{ $listing->dr }}</span>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <span class="px-2.5 py-1 bg-emerald-50 text-emerald-700 rounded-lg font-medium text-xs">
                            {{ $listing->traffic }}
                        </span>
                    </td>
                    <td class="px-6 py-4">
                        <div class="flex flex-col">
                            <span class="font-bold text-gray-900">${{ number_format($listing->price, 2) }}</span>
                            @if($listing->original_price)
                            <span class="text-xs text-gray-400 line-through">${{ number_format($listing->original_price, 2) }}</span>
                            @endif
                        </div>
                    </td>
                    <td class="px-6 py-4 text-gray-500 capitalize">
                        {{ $listing->link_type }}
                    </td>
                    <td class="px-6 py-4 text-right">
                        <div class="flex items-center justify-end space-x-2">
                            <a href="{{ route('admin.listings.edit', $listing->id) }}" class="p-2 text-indigo-600 hover:bg-indigo-50 rounded-lg transition-colors" title="Edit">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </a>
                            <form action="{{ route('admin.listings.destroy', $listing->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this listing?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="p-2 text-red-600 hover:bg-red-50 rounded-lg transition-colors" title="Delete">
                                    <i class="fa-solid fa-trash-can"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="px-6 py-12 text-center text-gray-500 bg-white">
                        <div class="flex flex-col items-center">
                            <i class="fa-solid fa-folder-open text-4xl text-gray-200 mb-3"></i>
                            <p class="font-medium text-gray-600">No websites found in inventory</p>
                            <p class="text-sm mt-1">Start by adding your first guest post site.</p>
                        </div>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    
    @if($listings->hasPages())
    <div class="px-6 py-4 bg-gray-50/50 border-t border-gray-200">
        {{ $listings->links() }}
    </div>
    @endif
</div>
@endsection
