@extends('admin.layout')

@section('content')
<div class="mb-8">
    <a href="{{ route('admin.listings.index') }}" class="inline-flex items-center text-sm font-medium text-gray-500 hover:text-indigo-600 transition-colors mb-4">
        <i class="fa-solid fa-arrow-left mr-2"></i>
        Back to Inventory
    </a>
    <h1 class="text-3xl font-bold text-gray-900">Add New Website</h1>
    <p class="text-gray-600 mt-1">Add a new website to the guest post marketplace.</p>
</div>

<div class="max-w-4xl">
    <form action="{{ route('admin.listings.store') }}" method="POST" class="space-y-6">
        @csrf
        
        <div class="glass rounded-2xl p-6 lg:p-8 shadow-sm border border-gray-200">
            <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                <i class="fa-solid fa-globe mr-3 text-indigo-500"></i>
                Website Information
            </h2>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Title -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Website Title / Domain Name</label>
                    <input type="text" name="title" value="{{ old('title') }}" required placeholder="e.g. Example.com"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    @error('title') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                </div>

                <!-- URL -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Website URL (Optional)</label>
                    <input type="text" name="url" value="{{ old('url') }}" placeholder="https://example.com"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    @error('url') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                </div>

                <!-- Sample Post Link -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Sample Post Link (Optional)</label>
                    <input type="text" name="sample_post_link" value="{{ old('sample_post_link') }}" placeholder="https://example.com/sample-post"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    @error('sample_post_link') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                </div>

                <!-- Category -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Category</label>
                    <input type="text" name="category" value="{{ old('category') }}" required placeholder="e.g. Tech, Health"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    @error('category') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                </div>

                <!-- Link Type -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Link Type</label>
                    <select name="link_type" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all bg-white">
                        <option value="Dofollow" {{ old('link_type') == 'Dofollow' ? 'selected' : '' }}>Dofollow</option>
                        <option value="Nofollow" {{ old('link_type') == 'Nofollow' ? 'selected' : '' }}>Nofollow</option>
                    </select>
                    @error('link_type') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                </div>
            </div>
        </div>

        <div class="glass rounded-2xl p-6 lg:p-8 shadow-sm border border-gray-200">
            <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                <i class="fa-solid fa-chart-line mr-3 text-indigo-500"></i>
                SEO Metrics & Pricing
            </h2>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- DA -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Domain Authority (DA)</label>
                    <input type="number" name="da" value="{{ old('da') }}" required placeholder="0-100" min="0" max="100"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    @error('da') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                </div>

                <!-- DR -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Domain Rating (DR)</label>
                    <input type="number" name="dr" value="{{ old('dr') }}" required placeholder="0-100" min="0" max="100"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    @error('dr') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                </div>

                <!-- Traffic -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Monthly Traffic</label>
                    <input type="text" name="traffic" value="{{ old('traffic') }}" required placeholder="e.g. 50K+, 1M"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    @error('traffic') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                </div>

                <!-- Spam Score -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Spam Score</label>
                    <input type="text" name="spam_score" value="{{ old('spam_score') }}" placeholder="e.g. 1%, N/A"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    @error('spam_score') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                </div>

                <!-- Price -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Price ($)</label>
                    <div class="relative">
                        <span class="absolute left-4 top-3.5 text-gray-400">$</span>
                        <input type="number" name="price" value="{{ old('price') }}" required step="0.01" placeholder="0.00"
                            class="w-full pl-8 pr-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    </div>
                    @error('price') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                </div>

                <!-- Original Price -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Original Price (For Discount Display)</label>
                    <div class="relative">
                        <span class="absolute left-4 top-3.5 text-gray-400">$</span>
                        <input type="number" name="original_price" value="{{ old('original_price') }}" step="0.01" placeholder="0.00"
                            class="w-full pl-8 pr-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    </div>
                    @error('original_price') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                </div>
            </div>
        </div>

        <div class="glass rounded-2xl p-6 lg:p-8 shadow-sm border border-gray-200">
            <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                <i class="fa-solid fa-align-left mr-3 text-indigo-500"></i>
                Additional Details
            </h2>
            
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Description</label>
                <textarea name="description" rows="4" placeholder="Briefly describe the website's audience or niche highlights..."
                    class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">{{ old('description') }}</textarea>
                @error('description') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
            </div>
        </div>

        <div class="flex items-center justify-end space-x-4 pt-4">
            <a href="{{ route('admin.listings.index') }}" class="px-6 py-3 text-sm font-semibold text-gray-600 hover:text-gray-900 transition-colors">
                Cancel
            </a>
            <button type="submit" class="inline-flex items-center px-8 py-3 bg-indigo-600 hover:bg-indigo-700 text-white font-bold rounded-xl transition-all shadow-lg shadow-indigo-100">
                <i class="fa-solid fa-cloud-arrow-up mr-2"></i>
                Save Website
            </button>
        </div>
    </form>
</div>
@endsection
