@extends('admin.layout')

@section('content')
<div class="mb-8">
    <h1 class="text-3xl font-bold text-gray-900">Dashboard Overview</h1>
    <p class="text-gray-500">Welcome back, here's what's happening with your site today.</p>
</div>

<!-- Stats Grid -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6 mb-8">
    <!-- Total Blogs Card -->
    <div class="stat-card bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex items-center">
        <div class="w-12 h-12 bg-indigo-100 text-indigo-600 rounded-xl flex items-center justify-center text-xl mr-4">
            <i class="fa-solid fa-newspaper"></i>
        </div>
        <div>
            <p class="text-sm font-medium text-gray-500 uppercase">Blogs</p>
            <h3 class="text-2xl font-bold text-gray-900">{{ $totalBlogs }}</h3>
        </div>
    </div>

    <!-- Inventory / Guest Posts Card -->
    <div class="stat-card bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex items-center">
        <div class="w-12 h-12 bg-emerald-100 text-emerald-600 rounded-xl flex items-center justify-center text-xl mr-4">
            <i class="fa-solid fa-list-check"></i>
        </div>
        <div>
            <p class="text-sm font-medium text-gray-500 uppercase">Websites</p>
            <h3 class="text-2xl font-bold text-gray-900">{{ $totalGuestPosts }}</h3>
        </div>
    </div>

    <!-- Total Guest Post Orders Card -->
    <div class="stat-card bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex items-center">
        <div class="w-12 h-12 bg-blue-100 text-blue-600 rounded-xl flex items-center justify-center text-xl mr-4">
            <i class="fa-solid fa-box-open"></i>
        </div>
        <div>
            <p class="text-sm font-medium text-gray-500 uppercase">GP Orders</p>
            <h3 class="text-2xl font-bold text-gray-900">{{ $guestPostOrdersCount }}</h3>
        </div>
    </div>

    <!-- Service Orders Card -->
    <div class="stat-card bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex items-center">
        <div class="w-12 h-12 bg-orange-100 text-orange-600 rounded-xl flex items-center justify-center text-xl mr-4">
            <i class="fa-solid fa-cart-shopping"></i>
        </div>
        <div>
            <p class="text-sm font-medium text-gray-500 uppercase">SVC Orders</p>
            <h3 class="text-2xl font-bold text-gray-900">{{ $serviceOrdersCount }}</h3>
        </div>
    </div>

    <!-- Total Messages Card -->
    <div class="stat-card bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex items-center">
        <div class="w-12 h-12 bg-purple-100 text-purple-600 rounded-xl flex items-center justify-center text-xl mr-4">
            <i class="fa-solid fa-envelope"></i>
        </div>
        <div>
            <p class="text-sm font-medium text-gray-500 uppercase">Messages</p>
            <h3 class="text-2xl font-bold text-gray-900">{{ $totalMessages }}</h3>
        </div>
    </div>
</div>

<!-- Charts Section -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
    <!-- Main Activity Chart -->
    <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100">
        <div class="flex items-center justify-between mb-6">
            <h2 class="text-lg font-bold text-gray-900">Activity Analytics (Last 7 Days)</h2>
            <div class="flex items-center space-x-2 text-xs">
                <span class="flex items-center"><span class="w-3 h-3 bg-indigo-500 rounded-full mr-1"></span> Activity</span>
            </div>
        </div>
        <div class="relative h-[300px]">
            <canvas id="analyticsChart"></canvas>
        </div>
    </div>

    <!-- Engagement Overview -->
    <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100">
        <h2 class="text-lg font-bold text-gray-900 mb-6">Engagement Overview</h2>
        <div class="relative h-[300px]">
            <canvas id="engagementChart"></canvas>
        </div>
    </div>
</div>

<!-- Recent Activity Grid -->
<div class="grid grid-cols-1 xl:grid-cols-2 gap-8 mb-8">
    <!-- Recent Messages Table -->
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="p-6 border-b border-gray-100 flex items-center justify-between">
            <h2 class="text-lg font-bold text-gray-900">Recent Messages</h2>
            <a href="{{ route('admin.messages.index') }}" class="text-indigo-600 text-sm font-semibold hover:underline">View All</a>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full text-left">
                <thead>
                    <tr class="bg-gray-50 text-gray-500 text-xs uppercase tracking-wider">
                        <th class="px-6 py-4 font-semibold">Name</th>
                        <th class="px-6 py-4 font-semibold text-right">Date</th>
                        <th class="px-6 py-4 font-semibold text-center">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($messages->take(5) as $msg)
                    <tr class="hover:bg-gray-50 transition-colors">
                        <td class="px-6 py-4">
                            <div class="font-medium text-gray-900">{{ $msg->first_name }} {{ $msg->last_name }}</div>
                            <div class="text-xs text-gray-500">{{ $msg->email }}</div>
                        </td>
                        <td class="px-6 py-4 text-right text-gray-500 text-sm">{{ $msg->created_at->format('M d') }}</td>
                        <td class="px-6 py-4 text-center">
                            <button onclick="viewMessage('{{ $msg->first_name }} {{ $msg->last_name }}', '{{ $msg->email }}', '{{ $msg->subject }}', '{{ addslashes(str_replace(["\r", "\n"], ' ', $msg->message)) }}')" class="text-indigo-500 hover:text-indigo-700 transition-colors">
                                <i class="fa-solid fa-eye"></i>
                            </button>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="3" class="px-6 py-10 text-center text-gray-500">No messages found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Recent Orders Table -->
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="p-6 border-b border-gray-100 flex items-center justify-between">
            <h2 class="text-lg font-bold text-gray-900">Recent Service Orders</h2>
            <a href="{{ route('admin.orders.index') }}" class="text-indigo-600 text-sm font-semibold hover:underline">View All</a>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full text-left">
                <thead>
                    <tr class="bg-gray-50 text-gray-500 text-xs uppercase tracking-wider">
                        <th class="px-6 py-4 font-semibold">Service/Order</th>
                        <th class="px-6 py-4 font-semibold">Price</th>
                        <th class="px-6 py-4 font-semibold text-right">Status</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($recentOrders as $order)
                    <tr class="hover:bg-gray-50 transition-colors">
                        <td class="px-6 py-4">
                            <div class="text-xs font-bold text-indigo-600 uppercase mb-0.5">#RF-{{ str_pad($order->id, 5, '0', STR_PAD_LEFT) }}</div>
                            <div class="font-medium text-gray-900">{{ $order->service_type }}</div>
                            <div class="text-xs text-gray-500 truncate max-w-[150px]">{{ $order->plan_name }}</div>
                        </td>
                        <td class="px-6 py-4 font-bold text-gray-900">${{ number_format($order->price, 0) }}</td>
                        <td class="px-6 py-4 text-right">
                            <span class="px-2 py-0.5 rounded-full text-[10px] font-bold {{ $order->payment_status === 'completed' ? 'bg-green-100 text-green-700' : 'bg-yellow-100 text-yellow-700' }}">
                                {{ strtoupper($order->payment_status) }}
                            </span>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="3" class="px-6 py-10 text-center text-gray-500">No orders found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Message View Modal -->
<div id="messageModal" class="fixed inset-0 z-50 flex items-center justify-center hidden">
    <div class="fixed inset-0 bg-gray-900/50 backdrop-blur-sm" onclick="closeModal()"></div>
    <div class="bg-white rounded-2xl shadow-xl z-10 w-full max-w-lg mx-4 overflow-hidden relative">
        <div class="p-6 border-b border-gray-100 flex items-center justify-between">
            <h3 class="text-xl font-bold text-gray-900">Contact Message</h3>
            <button onclick="closeModal()" class="text-gray-400 hover:text-gray-600 transition-colors">
                <i class="fa-solid fa-times text-xl"></i>
            </button>
        </div>
        <div class="p-6 space-y-4">
            <div>
                <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">From</p>
                <p id="modalName" class="text-gray-900 font-medium"></p>
                <p id="modalEmail" class="text-sm text-indigo-600"></p>
            </div>
            <div>
                <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Subject</p>
                <p id="modalSubject" class="text-gray-900"></p>
            </div>
            <div>
                <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Message</p>
                <div class="mt-1 p-4 bg-gray-50 rounded-xl text-gray-700 whitespace-pre-wrap max-h-60 overflow-y-auto" id="modalMessage"></div>
            </div>
        </div>
        <div class="p-6 border-t border-gray-100 flex justify-end">
            <button onclick="closeModal()" class="px-6 py-2 bg-gray-100 text-gray-700 font-semibold rounded-xl hover:bg-gray-200 transition-colors">Close</button>
        </div>
    </div>
</div>

<script>
    // Activity Analytics Chart
    const ctx = document.getElementById('analyticsChart').getContext('2d');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: {!! json_encode($chartLabels) !!},
            datasets: [{
                label: 'Combined Activity',
                data: {!! json_encode($activityData) !!},
                borderColor: '#6366f1',
                backgroundColor: 'rgba(99, 102, 241, 0.1)',
                fill: true,
                tension: 0.4,
                borderWidth: 3,
                pointBackgroundColor: '#6366f1',
                pointRadius: 4,
                pointHoverRadius: 6
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { display: false },
                tooltip: {
                    backgroundColor: '#1e1b4b',
                    titleFont: { size: 14, weight: 'bold' },
                    bodyFont: { size: 13 },
                    padding: 12,
                    displayColors: false
                }
            },
            scales: {
                y: { 
                    beginAtZero: true, 
                    grid: { color: '#f3f4f6' },
                    ticks: { stepSize: 1, color: '#9ca3af' }
                },
                x: { 
                    grid: { display: false },
                    ticks: { color: '#9ca3af' }
                }
            }
        }
    });

    // Engagement Overview Chart
    const engagementCtx = document.getElementById('engagementChart').getContext('2d');
    new Chart(engagementCtx, {
        type: 'doughnut',
        data: {
            labels: ['Blogs', 'Inventory', 'Messages', 'Orders'],
            datasets: [{
                data: [{{ $totalBlogs }}, {{ $totalGuestPosts }}, {{ $totalMessages }}, {{ $totalOrders }}],
                backgroundColor: ['#6366f1', '#10b981', '#3b82f6', '#f59e0b'],
                borderWidth: 0,
                hoverOffset: 15
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { 
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true,
                        font: { size: 12, weight: '500' }
                    }
                },
                tooltip: {
                    padding: 12,
                    backgroundColor: '#1e1b4b',
                }
            },
            cutout: '75%'
        }
    });

    function viewMessage(name, email, subject, message) {
        document.getElementById('modalName').textContent = name;
        document.getElementById('modalEmail').textContent = email;
        document.getElementById('modalSubject').textContent = subject;
        document.getElementById('modalMessage').textContent = message;
        document.getElementById('messageModal').classList.remove('hidden');
    }

    function closeModal() {
        document.getElementById('messageModal').classList.add('hidden');
    }
</script>
@endsection
