<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_orders', function (Blueprint $table) {
            $table->id();
            $table->string('service_type'); // seo, edu, niche
            $table->string('plan_name');
            $table->decimal('price', 10, 2);
            $table->string('customer_email');
            $table->string('target_url');
            $table->string('topic')->nullable();
            $table->string('whatsapp_number')->nullable();
            $table->string('article_file')->nullable();
            $table->enum('payment_status', ['pending', 'completed', 'failed', 'refunded'])->default('pending');
            $table->enum('order_status', ['new', 'processing', 'completed', 'cancelled'])->default('new');
            $table->string('transaction_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_orders');
    }
};
