<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Listing extends Model
{
    protected $fillable = [
        'title',
        'slug',
        'url',
        'sample_post_link',
        'category',
        'link_type',
        'da',
        'dr',
        'traffic',
        'description',
        'spam_score',
        'price',
        'original_price',
    ];

    /**
     * Boot the model.
     */
    protected static function boot()
    {
        parent::boot();

        static::creating(function (Listing $listing) {
            if (empty($listing->slug)) {
                $listing->slug = static::generateUniqueSlug($listing->title);
            }
        });

        static::updating(function (Listing $listing) {
            if ($listing->isDirty('title') || empty($listing->slug)) {
                $listing->slug = static::generateUniqueSlug($listing->title, $listing->id);
            }
        });
    }

    /**
     * Generate a unique slug based on the given title.
     */
    public static function generateUniqueSlug(string $title, ?int $ignoreId = null): string
    {
        $baseSlug = Str::slug($title);
        $slug = $baseSlug;
        $counter = 1;

        while (static::query()
            ->when($ignoreId, fn($q) => $q->where('id', '!=', $ignoreId))
            ->where('slug', $slug)
            ->exists()
        ) {
            $slug = $baseSlug.'-'.$counter;
            $counter++;
        }

        return $slug;
    }
}
