<?php

namespace App\Http\Controllers;

use App\Models\Listing;
use Illuminate\Http\Request;

class GuestPostController extends Controller
{
    public function index(Request $request)
    {
        $query = Listing::query();

        if ($request->has('search') && $request->get('search')) {
            $search = $request->get('search');
            $query->where(function($q) use ($search) {
                $q->where('title', 'like', "%$search%")
                  ->orWhere('category', 'like', "%$search%")
                  ->orWhere('link_type', 'like', "%$search%")
                  ->orWhere('url', 'like', "%$search%")
                  ->orWhere('da', 'like', "%$search%")
                  ->orWhere('dr', 'like', "%$search%")
                  ->orWhere('traffic', 'like', "%$search%")
                  ->orWhere('spam_score', 'like', "%$search%")
                  ->orWhere('price', 'like', "%$search%");
            });
        }

        $listings = $query->latest()->paginate(10)->withQueryString();
        
        if ($request->ajax()) {
            return view('partials.guest-post-list', compact('listings'))->render();
        }

        return view('pages.guest-post', compact('listings'));
    }

    public function show(string $slug)
    {
        $listing = Listing::where('slug', $slug)->firstOrFail();

        return view('pages.product', compact('listing'));
    }
}
