<?php

namespace App\Http\Controllers;

use App\Mail\ContactMessageMail;
use App\Models\Contact;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
   public function store(Request $request)
    {
        //  Validation       
        $request->validate([
            'first_name' => 'required|string|max:100|regex:/^[\pL\s\-]+$/u',
            'last_name'  => 'required|string|max:100|regex:/^[\pL\s\-]+$/u',
            'email'      => 'required|email:rfc,filter',
            'subject'    => 'nullable|string|max:150',
            'message'    => 'required|string|min:2|max:2000',
        ]);

        // Create contact record
        $contact = Contact::create($request->all());

        try {
            // Send mail to admin
            $adminEmail = env('ADMIN_EMAIL', 'zainabmemon061@gmail.com');
            if ($adminEmail) {
                // Use queue for better performance if configured
                Mail::to($adminEmail)->queue(new ContactMessageMail($contact));
            }

            // Send copy to specific email if different (also queued)
            if ($adminEmail !== 'zainabmemon061@gmail.com') {
                Mail::to('zainabmemon061@gmail.com')->queue(new ContactMessageMail($contact));
            }
        } catch (\Exception $e) {
            \Log::error('Contact Form Email Failed: ' . $e->getMessage());
        }

        //  Success response
        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Message sent and saved successfully!'
            ]);
        }

        return back()->with('success', 'Message sent and saved successfully!');
    }
}
